/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.mysticalworld.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageFallBladesFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellHarvest;
import epicsquid.roots.spell.SpellShatter;
import epicsquid.roots.util.OreDictCache;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreIngredient;

public class SpellNaturesScythe
extends SpellBase {
    private static final MethodHandle GET_SILK_DROP;
    public static final ItemStack SHEARS;
    public static Property.PropertyCooldown PROP_COOLDOWN;
    public static Property.PropertyCastType PROP_CAST_TYPE;
    public static Property.PropertyCost PROP_COST;
    public static Property<Integer> PROP_RADIUS;
    public static Property<Integer> PROP_RADIUS_Y;
    public static Property<Integer> PROP_INTERVAL;
    public static Property<Integer> PROP_MAX_AFFECTED;
    public static Property<String> PROP_TREE_DICT;
    public static Property<String> PROP_WEB_DICT;
    public static Property<String> PROP_GRASS_DICT;
    public static Property<String> PROP_MUSHROOM_DICT;
    public static Property<String> PROP_FLOWER_DICT;
    public static Property<String> PROP_VINES_DICT;
    public static Modifier WEBS;
    public static Modifier LEAVES;
    public static Modifier MAGNETISM;
    public static Modifier FORTUNE;
    public static Modifier VOID;
    public static Modifier GRASS;
    public static Modifier MUSHROOM;
    public static Modifier FLOWER;
    public static Modifier SPEED;
    public static Modifier SILK_TOUCH;
    public static ResourceLocation spellName;
    public static SpellNaturesScythe instance;
    private int radius;
    private int radius_y;
    private int interval;
    private int max_affected;
    private String tree;
    private String web;
    private String grass;
    private String mushroom;
    private String flower;
    private String vines;

    public SpellNaturesScythe(ResourceLocation name) {
        super(name, TextFormatting.DARK_GREEN, 0.2509804f, 0.9411765f, 0.09411765f, 0.101960786f, 0.43137255f, 0.050980393f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST, PROP_RADIUS, PROP_RADIUS_Y, PROP_INTERVAL, PROP_MAX_AFFECTED, PROP_TREE_DICT, PROP_WEB_DICT, PROP_GRASS_DICT, PROP_MUSHROOM_DICT, PROP_FLOWER_DICT, PROP_VINES_DICT);
        this.acceptModifiers(WEBS, LEAVES, MAGNETISM, FORTUNE, VOID, GRASS, MUSHROOM, FLOWER, SPEED, SILK_TOUCH);
    }

    @Override
    public void init() {
        this.addIngredients(new OreIngredient("wildroot"), new OreIngredient("wildroot"), new ItemStack(ModItems.aubergine), new ItemStack(Items.field_151018_J), new OreIngredient("tallgrass"));
        this.setCastSound(ModSounds.Spells.NATURES_SCYTHE);
    }

    @Override
    public boolean cast(EntityPlayer caster, StaffModifierInstanceList info, int ticks) {
        int x = this.max_affected;
        if (info.has(SPEED)) {
            x *= 2;
        }
        if (!(info.has(WEBS) || info.has(LEAVES) || info.has(GRASS) || info.has(MUSHROOM) || info.has(FLOWER))) {
            caster.func_145747_a(new TextComponentTranslation("roots.message.natures_scythe.no_modifier", new Object[]{new TextComponentTranslation(WEBS.getTranslationKey(), new Object[0]), new TextComponentTranslation(LEAVES.getTranslationKey(), new Object[0]), new TextComponentTranslation(GRASS.getTranslationKey(), new Object[0]), new TextComponentTranslation(MUSHROOM.getTranslationKey(), new Object[0]), new TextComponentTranslation(FLOWER.getTranslationKey(), new Object[0])}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            return false;
        }
        int interval = Math.max(1, this.interval);
        if (ticks % interval == 0) {
            return false;
        }
        World world = caster.field_70170_p;
        List blocks = Util.getBlocksWithinRadius((World)caster.field_70170_p, (BlockPos)caster.func_180425_c(), (float)this.radius, (float)this.radius_y, (float)this.radius, pos -> this.ifAffectedByNaturesScythe(world, (BlockPos)pos, info));
        if (blocks.isEmpty()) {
            return false;
        }
        ArrayList<Function<ItemStack, ItemStack>> converters = new ArrayList<Function<ItemStack, ItemStack>>();
        for (int i = 0; i <= x; ++i) {
            BlockPos pos2 = (BlockPos)blocks.get(Util.rand.nextInt(blocks.size()));
            if (world.field_72995_K) continue;
            if (info.has(VOID)) {
                world.func_175655_b(pos2, false);
            } else {
                this.breakBlock(world, pos2, info, caster, converters);
            }
            world.func_184133_a(null, pos2, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 0.5f, 1.0f);
            PacketHandler.sendToAllTracking((IMessage)new MessageFallBladesFX(pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p(), false), (World)world, (BlockPos)pos2);
        }
        return true;
    }

    public boolean canSilkTouch(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        Block block = state.func_177230_c();
        return block instanceof IShearable && ((IShearable)block).isShearable(SHEARS, (IBlockAccess)world, pos) || block.canSilkHarvest(world, pos, state, player);
    }

    public void breakBlock(World world, BlockPos pos, StaffModifierInstanceList info, EntityPlayer player, List<Function<ItemStack, ItemStack>> converters) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int fortune = info.has(FORTUNE) || info.has(SpellShatter.FORTUNE) ? 2 : 0;
        int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)GameType.SURVIVAL, (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
        if (xp == -1) {
            return;
        }
        xp = block.getExpDrop(state, (IBlockAccess)world, pos, fortune);
        boolean skip = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (info.has(SILK_TOUCH) || info.has(SpellHarvest.SILK_TOUCH) || info.has(SpellShatter.SILK_TOUCH)) {
            if (block instanceof IShearable && ((IShearable)block).isShearable(SHEARS, (IBlockAccess)world, pos)) {
                IShearable shearable = (IShearable)block;
                drops.addAll(shearable.onSheared(SHEARS, (IBlockAccess)player.field_70170_p, pos, fortune));
                world.func_175655_b(pos, false);
            } else if (block.canSilkHarvest(world, pos, state, player)) {
                ItemStack silked;
                try {
                    silked = GET_SILK_DROP.invokeExact(block, state);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("Unable to get silk touch drop!?", throwable);
                }
                if (!silked.func_190926_b()) {
                    drops.add(silked);
                }
                ForgeEventFactory.fireBlockHarvesting(drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)true, (EntityPlayer)player);
                world.func_175655_b(pos, false);
            } else {
                skip = true;
            }
        } else {
            skip = true;
        }
        if (skip) {
            NonNullList dropped = NonNullList.func_191196_a();
            block.getDrops(dropped, (IBlockAccess)world, pos, state, fortune);
            drops.addAll((Collection<ItemStack>)dropped);
            ForgeEventFactory.fireBlockHarvesting((List)dropped, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)true, (EntityPlayer)player);
            world.func_175655_b(pos, false);
        }
        boolean magnet = info.has(MAGNETISM) || info.has(SpellHarvest.MAGNETISM) || info.has(SpellShatter.MAGNETISM);
        for (ItemStack item : drops) {
            if (!converters.isEmpty()) {
                for (Function<ItemStack, ItemStack> converter : converters) {
                    item = converter.apply(item);
                }
            }
            if (magnet) {
                ItemUtil.spawnItem((World)world, (BlockPos)player.func_180425_c(), (ItemStack)item);
                continue;
            }
            ItemUtil.spawnItem((World)world, (BlockPos)pos, (ItemStack)item);
        }
        if (xp > 0) {
            BlockPos pos2 = pos;
            if (magnet) {
                pos2 = player.func_180425_c();
            }
            while (xp > 0) {
                int i = EntityXPOrb.func_70527_a((int)xp);
                xp -= i;
                world.func_72838_d((Entity)new EntityXPOrb(world, (double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5, i));
            }
        }
    }

    private boolean ifAffectedByNaturesScythe(World world, BlockPos pos, StaffModifierInstanceList info) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (info.has(WEBS) && (block instanceof BlockWeb || OreDictCache.matches(this.web, state))) {
            return true;
        }
        if (info.has(LEAVES) && (block instanceof BlockLeaves || OreDictCache.matches(this.tree, state))) {
            return true;
        }
        if (info.has(GRASS) && (block == Blocks.field_150329_H || block == Blocks.field_150398_cm && (state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.FERN || state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) == BlockDoublePlant.EnumPlantType.GRASS) || OreDictCache.matches(this.grass, state) || block instanceof BlockVine || OreDictCache.matches(this.vines, state))) {
            return true;
        }
        if (info.has(FLOWER) && (block instanceof BlockFlower || block instanceof BlockDoublePlant && state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) != BlockDoublePlant.EnumPlantType.GRASS && state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a) != BlockDoublePlant.EnumPlantType.FERN || OreDictCache.matches(this.flower, state))) {
            return true;
        }
        if (info.has(MUSHROOM)) {
            return block instanceof BlockMushroom || OreDictCache.matches(this.mushroom, state);
        }
        return false;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.radius = this.properties.get(PROP_RADIUS);
        this.radius_y = this.properties.get(PROP_RADIUS_Y);
        this.interval = this.properties.get(PROP_INTERVAL);
        this.flower = this.properties.get(PROP_FLOWER_DICT);
        this.grass = this.properties.get(PROP_GRASS_DICT);
        this.mushroom = this.properties.get(PROP_MUSHROOM_DICT);
        this.tree = this.properties.get(PROP_TREE_DICT);
        this.vines = this.properties.get(PROP_VINES_DICT);
        this.web = this.properties.get(PROP_WEB_DICT);
        this.max_affected = this.properties.get(PROP_MAX_AFFECTED);
    }

    static {
        SHEARS = new ItemStack((Item)Items.field_151097_aZ);
        try {
            Method getSilkDrop = ObfuscationReflectionHelper.findMethod(Block.class, (String)"func_180643_i", ItemStack.class, (Class[])new Class[]{IBlockState.class});
            getSilkDrop.setAccessible(true);
            GET_SILK_DROP = MethodHandles.lookup().unreflect(getSilkDrop).asType(MethodType.methodType(ItemStack.class, Block.class, IBlockState.class));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to properly handle silk touch drops", e);
        }
        PROP_COOLDOWN = new Property.PropertyCooldown(160);
        PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.CONTINUOUS);
        PROP_COST = new Property.PropertyCost(new SpellBase.SpellCost("stalicripe", 0.125));
        PROP_RADIUS = new Property<Integer>("radius", 12).setDescription("horizontal radius of the area in which the spell takes effect");
        PROP_RADIUS_Y = new Property<Integer>("radius_y", 5).setDescription("radius on the Y axis of the area in which the spell takes effect");
        PROP_INTERVAL = new Property<Integer>("interval", 2).setDescription("interval in ticks between each harvested block segment");
        PROP_MAX_AFFECTED = new Property<Integer>("max_affected", 3).setDescription("maximum number of blocks affected each tick per enabled type");
        PROP_TREE_DICT = new Property<String>("tree_dictionary", "treeLeaves").setDescription("the ore dictionary entry that should be used to identify leaves");
        PROP_WEB_DICT = new Property<String>("web_dictionary", "webs").setDescription("the ore dictionary entry that should be used to identify cobwebs in addition to the standard vanilla block");
        PROP_GRASS_DICT = new Property<String>("grass_dictionary", "tallgrass").setDescription("the ore dictionary entry that should be used to identify grass in addition to the standard vanilla blocks");
        PROP_MUSHROOM_DICT = new Property<String>("mushroom_dictionary", "mushrooms").setDescription("the ore dictionary entry that should be used to identify mushroom blocks (not huge mushrooms) in addition to those that derive from the default mushroom");
        PROP_FLOWER_DICT = new Property<String>("flower_dictionary", "flowers").setDescription("the ore dictionary entry that should be used to identify flower blocks in addition to those that derive from the default flowers");
        PROP_VINES_DICT = new Property<String>("vine_dictionary", "vines").setDescription("the ore dictionary entry that should be used to identify vines in addition to those that by default derive from vanilla vines");
        WEBS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "dewebbing"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.125)));
        LEAVES = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "leaf_harvester"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125)));
        MAGNETISM = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "magnetic_harvester"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.275)));
        FORTUNE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "fortunate_scythe"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.475)));
        VOID = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "voiding_scythe"), ModifierCores.SPIRIT_HERB, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.345))));
        GRASS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "grass_harvester"), ModifierCores.TERRA_MOSS, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.125)));
        MUSHROOM = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "mushroom_harvester"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.125)));
        FLOWER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "flower_harvester"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.125)));
        SPEED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "blazing_speed"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.475)));
        SILK_TOUCH = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "silk_scythe"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.675)));
        spellName = new ResourceLocation("roots", "spell_natures_scythe");
        instance = new SpellNaturesScythe(spellName);
    }
}

