/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.RayCastUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.mysticalworld.recipe.Ingredients;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.mechanics.Growth;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageLifeInfusionFX;
import epicsquid.roots.network.fx.MessageRampantLifeInfusionFX;
import epicsquid.roots.network.fx.MessageTradeResetFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.recipe.FlowerRecipe;
import epicsquid.roots.recipe.OreChances;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.OreDictCache;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreIngredient;

public class SpellGrowthInfusion
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(0);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.CONTINUOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("terra_moss", 0.325));
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 7).setDescription("radius on the X axis of the area in which the spell takes effect");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 7).setDescription("radius on the Y axis of the area in which the spell takes effect");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 7).setDescription("radius on the Z axis of the area in which the spell takes effect");
    public static Property<Integer> PROP_RADIUS_BREED_X = new Property<Integer>("radius_breed_x", 6).setDescription("radius on the X axis of the area in which the spell takes effect for the purposes of causing animals to go into breeding mode");
    public static Property<Integer> PROP_RADIUS_BREED_Y = new Property<Integer>("radius_breed_y", 6).setDescription("radius on the Y axis of the area in which the spell takes effect for the purposes of causing animals to go into breeding mode");
    public static Property<Integer> PROP_RADIUS_BREED_Z = new Property<Integer>("radius_breed_z", 6).setDescription("radius on the Z axis of the area in which the spell takes effect for the purposes of causing animals to go into breeding mode");
    public static Property<Integer> PROP_RADIUS_VILLAGER_X = new Property<Integer>("radius_villager_x", 6).setDescription("radius on the X axis of the area in which villagers would be searched for in order to reset trades");
    public static Property<Integer> PROP_RADIUS_VILLAGER_Y = new Property<Integer>("radius_villager_y", 6).setDescription("radius on the Y axis of the area in which villagers would be searched for in order to reset trades");
    public static Property<Integer> PROP_RADIUS_VILLAGER_Z = new Property<Integer>("radius_villager_z", 6).setDescription("radius on the Z axis of the area in which villagers would be searched for in order to reset trades");
    public static Property<Integer> PROP_RADIUS_BOOST = new Property<Integer>("radius_boost", 8).setDescription("how much the radius of the spell is boosted by with each rampant growth modifier");
    public static Property<Integer> PROP_GROWTH_TICKS = new Property<Integer>("growth_ticks", 3).setDescription("the number of times a random chance to grow the crop is applied every tick");
    public static Property<Integer> PROP_COUNT = new Property<Integer>("count", 2).setDescription("the number of crops selected to be grown each tick");
    public static Property<Integer> PROP_ADDITIONAL_COUNT = new Property<Integer>("additional_count", 4).setDescription("an additional number of crops from zero to the specified value minus 1 added to the default count");
    public static Property<Float> PROP_EMBIGGEN_CHANCE = new Property<Float>("embiggen_chance", Float.valueOf(0.05f)).setDescription("chance per tick to turn a mushroom into a big mushroom");
    public static Property<Integer> PROP_ANIMAL_GROWTH = new Property<Integer>("animal_growth_base", 20).setDescription("default number of ticks to age an entity by (1 second per channel)");
    public static Property<Integer> PROP_ANIMAL_GROWTH_VARY = new Property<Integer>("animal_growth_vary", 80).setDescription("additional ticks to age an entity by (varying from 0 to this value)");
    public static Property<Integer> PROP_ANIMAL_GROWTH_INTERVAL = new Property<Integer>("animal_growth_interval", 20).setDescription("how frequently additional ticks are added to an entity");
    public static Property<Float> PROP_VILLAGER_GROWTH = new Property<Float>("villager_growth_base", Float.valueOf(0.1f)).setDescription("chance per tick to reset trades of nearby villagers");
    public static Property<Integer> PROP_VILLAGER_COUNT = new Property<Integer>("village_count", 1).setDescription("the number of villagers that should have their trades reset (min 1)");
    public static Property<String> PROP_STONE_DICT = new Property<String>("stone_dictionary", "stone").setDescription("the ore dictionary entry that should be used to determine if a block can be targetted for ore conversion");
    public static Property<Float> PROP_STONE_CHANCE = new Property<Float>("stone_chance", Float.valueOf(0.01f)).setDescription("the chance per tick of eligible stone being converted to ore");
    public static Property<Integer> PROP_STONE_INTERVAL = new Property<Integer>("stone_interval", 40).setDescription("how often as an interval ore should try to be converted from stone");
    public static Modifier RADIUS1 = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "rampant_growth_i"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.275)));
    public static Modifier BREED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "rampant_breeding"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.345)));
    public static Modifier FLOWERS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "flower_spreading"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.25)));
    public static Modifier VILLAGERS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "false_night"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.675)));
    public static Modifier RADIUS2 = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "rampant_growth_ii"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.275)));
    public static Modifier EMBIGGEN = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "embiggening"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.45)));
    public static Modifier RADIUS3 = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "arms_of_air"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.275)));
    public static Modifier ANIMAL_GROWTH = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "incubation"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.475)));
    public static Modifier ORE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "ore_infusion"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.8)));
    public static Modifier HYDRATE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "hydration"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.125)));
    public static ResourceLocation spellName;
    public static SpellGrowthInfusion instance;
    private AxisAlignedBB breedingBox;
    private AxisAlignedBB villagerBox;
    private int radius_x;
    private int radius_y;
    private int radius_z;
    private int growth_ticks;
    private int additional_count;
    private int count;
    private int radius_boost;
    private int animal_growth;
    private int animal_growth_vary;
    private int animal_growth_interval;
    private int stone_interval;
    private int villager_count;
    private float embiggen_chance;
    private float stone_chance;
    private float villager_growth;
    private String stone_dict;

    public SpellGrowthInfusion(ResourceLocation name) {
        super(name, TextFormatting.YELLOW, 0.1882353f, 1.0f, 0.1882353f, 0.7529412f, 1.0f, 0.7529412f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_GROWTH_TICKS, PROP_COUNT, PROP_ADDITIONAL_COUNT, PROP_RADIUS_BOOST, PROP_RADIUS_BREED_X, PROP_RADIUS_BREED_Y, PROP_RADIUS_BREED_Z, PROP_RADIUS_VILLAGER_X, PROP_RADIUS_VILLAGER_Y, PROP_RADIUS_VILLAGER_Z, PROP_EMBIGGEN_CHANCE, PROP_ANIMAL_GROWTH, PROP_ANIMAL_GROWTH_VARY, PROP_STONE_CHANCE, PROP_STONE_DICT, PROP_VILLAGER_GROWTH, PROP_ANIMAL_GROWTH_INTERVAL, PROP_STONE_INTERVAL, PROP_VILLAGER_COUNT);
        this.acceptModifiers(RADIUS1, BREED, FLOWERS, VILLAGERS, RADIUS2, EMBIGGEN, RADIUS3, ANIMAL_GROWTH, ORE, HYDRATE);
    }

    @Override
    public void init() {
        this.addIngredients(new OreIngredient("allFlowers"), new OreIngredient("treeSapling"), new ItemStack(ModItems.terra_moss), Ingredients.AUBERGINE, new OreIngredient("cropWheat"));
        this.setCastSound(ModSounds.Spells.GROWTH_INFUSION);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        List<BlockPos> positions;
        List villagers;
        List animals;
        boolean didSomething = false;
        if (info.has(BREED)) {
            animals = player.field_70170_p.func_72872_a(EntityAnimal.class, this.breedingBox.func_186670_a(player.func_180425_c()));
            int count = 0;
            for (EntityAnimal animal : animals) {
                if (animal.func_70880_s() || animal.func_70874_b() != 0) continue;
                ++count;
                if (player.field_70170_p.field_72995_K) continue;
                animal.func_146082_f(player);
            }
            if (count != 0) {
                didSomething = true;
            }
        }
        if (info.has(ANIMAL_GROWTH) && ticks % this.animal_growth_interval == 0 && !(animals = player.field_70170_p.func_175647_a(EntityAnimal.class, this.breedingBox.func_186670_a(player.func_180425_c()), EntityAgeable::func_70631_g_)).isEmpty()) {
            didSomething = true;
            if (!player.field_70170_p.field_72995_K) {
                EntityAnimal choice = (EntityAnimal)animals.get(Util.rand.nextInt(animals.size()));
                int amount = this.animal_growth + Util.rand.nextInt(this.animal_growth_vary);
                choice.func_110195_a(amount);
            }
        }
        if (info.has(VILLAGERS) && Util.rand.nextDouble() < (double)this.villager_growth && !(villagers = player.field_70170_p.func_175647_a(EntityVillager.class, this.villagerBox.func_186670_a(player.func_180425_c()), o -> o != null && !o.func_70631_g_() && o.func_70660_b(MobEffects.field_76428_l) == null)).isEmpty()) {
            int q = this.villager_count;
            didSomething = true;
            if (!player.field_70170_p.field_72995_K) {
                while (q > 0 && !villagers.isEmpty()) {
                    EntityVillager villager = (EntityVillager)villagers.remove(Util.rand.nextInt(villagers.size()));
                    if (!(Util.rand.nextFloat() < this.villager_growth)) continue;
                    EntityPlayer oldPlayer = villager.func_70931_l_();
                    villager.func_70932_a_(player);
                    MerchantRecipeList recipes = villager.func_70934_b(player);
                    villager.func_70932_a_(oldPlayer);
                    boolean doReset = false;
                    if (recipes != null) {
                        for (FlowerRecipe recipe : recipes) {
                            if (!recipe.func_82784_g()) continue;
                            doReset = true;
                            break;
                        }
                    }
                    if (doReset) {
                        --q;
                        villager.field_70961_j = 40;
                        villager.field_70959_by = true;
                        villager.field_175565_bs = true;
                    } else {
                        villager.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200));
                    }
                    MessageTradeResetFX message = new MessageTradeResetFX(villager.field_70165_t, villager.field_70163_u + (double)villager.func_70047_e(), villager.field_70161_v, doReset);
                    PacketHandler.sendToAllTracking((IMessage)message, (Entity)villager);
                }
            }
        }
        boolean aoe = false;
        int boost = 0;
        Modifier init = null;
        if (info.has(RADIUS1)) {
            init = RADIUS1;
        } else if (info.has(RADIUS2)) {
            init = RADIUS2;
        } else if (info.has(RADIUS3)) {
            init = RADIUS3;
        }
        boolean bl = aoe = init != null;
        if (aoe) {
            if (info.has(RADIUS1) && init != RADIUS1) {
                boost += this.radius_boost;
            }
            if (info.has(RADIUS2) && init != RADIUS2) {
                boost += this.radius_boost;
            }
            if (info.has(RADIUS3) && init != RADIUS3) {
                boost += this.radius_boost;
            }
            if ((positions = Growth.collect(player.field_70170_p, player.func_180425_c(), this.radius_x + boost, this.radius_y + boost, this.radius_z + boost)).isEmpty()) {
                return false;
            }
        } else {
            IBlockState below;
            FlowerRecipe recipe;
            RayTraceResult result = RayCastUtil.rayTraceBlocksSight((World)player.field_70170_p, (Entity)player, (float)8.0f);
            if (result == null) return didSomething;
            if (result.field_72313_a != RayTraceResult.Type.BLOCK) return didSomething;
            BlockPos pos = result.func_178782_a();
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (info.has(FLOWERS) && (recipe = ModRecipes.getFlowerRecipe(state)) != null) {
                didSomething = true;
                if (!player.field_70170_p.field_72995_K) {
                    ItemUtil.spawnItem((World)player.field_70170_p, (BlockPos)pos, (ItemStack)recipe.getStack());
                }
            }
            if (info.has(EMBIGGEN)) {
                if (block instanceof BlockMushroom) {
                    BlockMushroom shroom;
                    didSomething = true;
                    if (!player.field_70170_p.field_72995_K && Util.rand.nextFloat() < this.embiggen_chance && !(shroom = (BlockMushroom)block).func_176485_d(player.field_70170_p, pos, state, Util.rand)) {
                        // empty if block
                    }
                } else if (block instanceof BlockSapling) {
                    didSomething = true;
                    if (!player.field_70170_p.field_72995_K && Util.rand.nextFloat() < this.embiggen_chance) {
                        BlockSapling sapling = (BlockSapling)block;
                        sapling.func_176476_e(player.field_70170_p, pos, state, Util.rand);
                    }
                }
            }
            if (info.has(ORE) && ticks % this.stone_interval == 0 && OreDictCache.matches(this.stone_dict, state) && Util.rand.nextFloat() < this.stone_chance) {
                didSomething = true;
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_175656_a(pos, OreChances.getRandomState());
                }
            }
            if (didSomething) return didSomething;
            if (!Growth.canGrow(player.field_70170_p, pos, state)) return didSomething;
            if (player.field_70170_p.field_72995_K) return didSomething;
            for (int i = 0; i < this.growth_ticks; ++i) {
                state.func_177230_c().func_180645_a(player.field_70170_p, pos, state, new Random());
            }
            if (info.has(HYDRATE) && (below = player.field_70170_p.func_180495_p(pos.func_177977_b())).func_177227_a().contains(BlockFarmland.field_176531_a)) {
                player.field_70170_p.func_180501_a(pos.func_177977_b(), below.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 18);
            }
            PacketHandler.sendToAllTracking((IMessage)new MessageLifeInfusionFX(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (Entity)player);
            return true;
        }
        if (player.field_70170_p.field_72995_K) return true;
        int i = 0;
        while (i < this.count + player.field_70170_p.field_73012_v.nextInt(this.additional_count)) {
            IBlockState below;
            BlockPos pos = positions.get(player.field_70170_p.field_73012_v.nextInt(positions.size()));
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            for (int j = 0; j < this.growth_ticks; ++j) {
                state.func_177230_c().func_180645_a(player.field_70170_p, pos, state, Util.rand);
            }
            if (info.has(HYDRATE) && (below = player.field_70170_p.func_180495_p(pos.func_177977_b())).func_177227_a().contains(BlockFarmland.field_176531_a)) {
                player.field_70170_p.func_180501_a(pos.func_177977_b(), below.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 18);
            }
            if (player.field_70170_p.field_73012_v.nextInt(3) == 0) {
                PacketHandler.sendToAllTracking((IMessage)new MessageRampantLifeInfusionFX(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (Entity)player);
            }
            ++i;
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.radius_x = this.properties.get(PROP_RADIUS_X);
        this.radius_y = this.properties.get(PROP_RADIUS_Y);
        this.radius_z = this.properties.get(PROP_RADIUS_Z);
        int radius_breed_x = this.properties.get(PROP_RADIUS_BREED_X);
        int radius_breed_y = this.properties.get(PROP_RADIUS_BREED_Y);
        int radius_breed_z = this.properties.get(PROP_RADIUS_BREED_Z);
        int radius_villager_x = this.properties.get(PROP_RADIUS_VILLAGER_X);
        int radius_villager_y = this.properties.get(PROP_RADIUS_VILLAGER_Y);
        int radius_villager_z = this.properties.get(PROP_RADIUS_VILLAGER_Z);
        this.growth_ticks = this.properties.get(PROP_GROWTH_TICKS);
        this.count = this.properties.get(PROP_COUNT);
        this.additional_count = this.properties.get(PROP_ADDITIONAL_COUNT);
        this.radius_boost = this.properties.get(PROP_RADIUS_BOOST);
        this.breedingBox = new AxisAlignedBB((double)(-radius_breed_x), (double)(-radius_breed_y), (double)(-radius_breed_z), (double)(radius_breed_x + 1), (double)(radius_breed_y + 1), (double)(radius_breed_z + 1));
        this.villagerBox = new AxisAlignedBB((double)(-radius_villager_x), (double)(-radius_villager_y), (double)(-radius_villager_z), (double)(radius_villager_x + 1), (double)(radius_villager_y + 1), (double)(radius_villager_z + 1));
        this.villager_count = this.properties.get(PROP_VILLAGER_COUNT);
        this.embiggen_chance = this.properties.get(PROP_EMBIGGEN_CHANCE).floatValue();
        this.animal_growth = this.properties.get(PROP_ANIMAL_GROWTH);
        this.animal_growth_vary = this.properties.get(PROP_ANIMAL_GROWTH_VARY);
        this.animal_growth_interval = this.properties.get(PROP_ANIMAL_GROWTH_INTERVAL);
        this.villager_growth = this.properties.get(PROP_VILLAGER_GROWTH).floatValue();
        this.stone_chance = this.properties.get(PROP_STONE_CHANCE).floatValue();
        this.stone_dict = this.properties.get(PROP_STONE_DICT);
        this.stone_interval = this.properties.get(PROP_STONE_INTERVAL);
    }

    static {
        FLOWERS.addConflicts(RADIUS1, RADIUS2, RADIUS3);
        ORE.addConflicts(RADIUS1, RADIUS2, RADIUS3);
        EMBIGGEN.addConflicts(RADIUS1, RADIUS2, RADIUS3);
        ANIMAL_GROWTH.addConflicts(RADIUS1, RADIUS2, RADIUS3);
        spellName = new ResourceLocation("roots", "spell_growth_infusion");
        instance = new SpellGrowthInfusion(spellName);
    }
}

