/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModPotions;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.EntityUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class SpellAquaBubble
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(1200);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("dewgonia", 1.5));
    public static Property.PropertyCost PROP_COST_2 = new Property.PropertyCost(new SpellBase.SpellCost("terra_moss", 0.5));
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(1200);
    public static Property<Double> PROP_ABSORPTION = new Property<Double>("absorption", 20.0).setDescription("the amount of health absorption granted");
    public static Property<Float> PROP_FIRE_REDUCTION = new Property<Float>("fire_reduction", Float.valueOf(0.6f)).setDescription("how much fire damage is multiplied by");
    public static Property<Float> PROP_LAVA_REDUCTION = new Property<Float>("lava_reduction", Float.valueOf(0.0f)).setDescription("how much lava damage is multiplied by");
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 5).setDescription("the radius to search for familiars and additional players within");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 5).setDescription("the radius to search for familiars and additional players within");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 5).setDescription("the radius to search for familiars and additional players within");
    public static Property<Float> PROP_KNOCKBACK = new Property<Float>("knockback", Float.valueOf(0.2f)).setDescription("the amount of knockback to be applied");
    public static Property<Float> PROP_AMPLIFIER = new Property<Float>("amplifier", Float.valueOf(0.6f)).setDescription("how much the effects of this spell should be amplified by");
    public static Property<Integer> PROP_SLOW_DURATION = new Property<Integer>("slowness_duration", 60).setDescription("the duration of time that the slowness effect is applied for");
    public static Property<Integer> PROP_SLOW_AMPLIFIER = new Property<Integer>("slowness_amplifier", 0).setDescription("the amplifier to be applied to the slowness effect");
    public static Property<Float> PROP_UNDEAD_REDUCTION = new Property<Float>("undead_reduction", Float.valueOf(0.4f)).setDescription("the percentage of damage (as a float) that you take from undead");
    public static Property<Integer> PROP_RESISTANCE_DURATION = new Property<Integer>("resistance_duration", 500).setDescription("how long the resistance buff should be added for");
    public static Property<Integer> PROP_RESISTANCE_AMPLIFIER = new Property<Integer>("resistance_amplifier", 0).setDescription("how much to amplify the resistance buff by");
    public static Property<Float> PROP_MAGIC_RESIST = new Property<Float>("magic_resistance", Float.valueOf(0.4f)).setDescription("how much magic damage is reduced by");
    public static Modifier AMPLIFIED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "bubble_amplified"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.975)));
    public static Modifier FAMILIARS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "faithful_sharing"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.275)));
    public static Modifier SLOW = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "barkskin"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.35)));
    public static Modifier MAGIC_RESIST = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "moon_bubble"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.725)));
    public static Modifier UNDEAD = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "spirit_bubble"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.375)));
    public static Modifier POISON_RESIST = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "poison_protection"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.375)));
    public static Modifier KNOCKBACK = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "bubble_knockback"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.275)));
    public static Modifier REFLECT_FIRE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "reflective_bubble"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.125)));
    public static Modifier RESISTANCE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "stoneskin"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.475)));
    public static ResourceLocation spellName = new ResourceLocation("roots", "spell_aqua_bubble");
    public static SpellAquaBubble instance = new SpellAquaBubble(spellName);
    public int duration;
    public int radius_x;
    public int radius_y;
    public int radius_z;
    public int slow_duration;
    public int slow_amplifier;
    public int resistance_duration;
    public int resistance_amplifier;
    public double absorption;
    public float fire_reduction;
    public float lava_reduction;
    public float knockback;
    public float undead_reduction;
    public float magic_reduction;
    public float amplifier;
    private AxisAlignedBB radius;

    public SpellAquaBubble(ResourceLocation name) {
        super(name, TextFormatting.AQUA, 0.92941177f, 0.9019608f, 0.34509805f, 0.3647059f, 0.81960785f, 0.87058824f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_COST_2, PROP_DURATION, PROP_ABSORPTION, PROP_FIRE_REDUCTION, PROP_LAVA_REDUCTION, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_KNOCKBACK, PROP_SLOW_AMPLIFIER, PROP_SLOW_DURATION, PROP_UNDEAD_REDUCTION, PROP_RESISTANCE_AMPLIFIER, PROP_RESISTANCE_DURATION, PROP_MAGIC_RESIST, PROP_AMPLIFIER);
        this.acceptModifiers(AMPLIFIED, FAMILIARS, SLOW, MAGIC_RESIST, UNDEAD, POISON_RESIST, KNOCKBACK, REFLECT_FIRE, RESISTANCE);
        this.setCastSound(ModSounds.Spells.AQUA_BUBBLE);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(Items.field_151131_as), new ItemStack(ModItems.dewgonia), new OreIngredient("snowball"), new OreIngredient("blockGlass"), new OreIngredient("gemQuartz"));
        this.setCastSound(ModSounds.Spells.AQUA_BUBBLE);
    }

    @Override
    public boolean cast(EntityPlayer caster, StaffModifierInstanceList info, int ticks) {
        int dur = this.duration;
        int dur2 = this.resistance_duration;
        if (info.has(AMPLIFIED)) {
            dur = (int)((float)dur + (float)this.duration * this.amplifier);
            dur2 = (int)((float)dur2 + (float)this.resistance_duration * this.amplifier);
        }
        if (!caster.field_70170_p.field_72995_K) {
            List entities;
            caster.getEntityData().func_74783_a(this.getCachedName(), info.toArray());
            caster.func_70690_d(new PotionEffect((Potion)ModPotions.aqua_bubble, dur, 0, false, false));
            if (info.has(RESISTANCE)) {
                caster.func_70690_d(new PotionEffect(MobEffects.field_76429_m, dur2, this.resistance_amplifier));
            }
            if (info.has(FAMILIARS) && !(entities = caster.field_70170_p.func_175647_a(EntityLivingBase.class, this.radius.func_186670_a(caster.func_180425_c()), o -> EntityUtil.isFamiliar(caster, (Entity)o))).isEmpty()) {
                EntityLivingBase other = (EntityLivingBase)entities.get(Util.rand.nextInt(entities.size()));
                other.getEntityData().func_74783_a(this.getCachedName(), info.toArray());
                other.func_70690_d(new PotionEffect((Potion)ModPotions.aqua_bubble, dur));
                if (info.has(RESISTANCE)) {
                    other.func_70690_d(new PotionEffect(MobEffects.field_76429_m, dur2, this.resistance_amplifier));
                }
            }
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.duration = this.properties.get(PROP_DURATION);
        this.absorption = this.properties.get(PROP_ABSORPTION);
        this.fire_reduction = this.properties.get(PROP_FIRE_REDUCTION).floatValue();
        this.lava_reduction = this.properties.get(PROP_LAVA_REDUCTION).floatValue();
        ModPotions.aqua_bubble.finalise(this);
        int[] radius = this.properties.getRadius();
        this.radius_x = radius[0];
        this.radius_y = radius[1];
        this.radius_z = radius[2];
        this.radius = new AxisAlignedBB((double)(-this.radius_x), (double)(-this.radius_y), (double)(-this.radius_z), (double)(this.radius_x + 1), (double)(this.radius_y + 1), (double)(this.radius_z + 1));
        this.knockback = this.properties.get(PROP_KNOCKBACK).floatValue();
        this.slow_amplifier = this.properties.get(PROP_SLOW_AMPLIFIER);
        this.slow_duration = this.properties.get(PROP_SLOW_DURATION);
        this.undead_reduction = this.properties.get(PROP_UNDEAD_REDUCTION).floatValue();
        this.resistance_amplifier = this.properties.get(PROP_RESISTANCE_AMPLIFIER);
        this.resistance_duration = this.properties.get(PROP_RESISTANCE_DURATION);
        this.magic_reduction = this.properties.get(PROP_MAGIC_RESIST).floatValue();
        this.amplifier = this.properties.get(PROP_AMPLIFIER).floatValue();
    }
}

