/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.entity.ritual.EntityRitualFrostLands;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.IColdRitual;
import epicsquid.roots.ritual.RitualBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class RitualFrostLands
extends RitualBase
implements IColdRitual {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(6400);
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 10).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 10).setDescription("Radius on the Y Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 10).setDescription("Radius on the Z Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_INTERVAL_HEAL = new Property<Integer>("interval_snowman_heal", 30).setDescription("number of TICKS between each snowman healing pulse (every pulse heals all snowmen completely)");
    public static Property<Float> PROP_INTERVAL_SPAWN = new Property<Float>("interval_snowman_spawn", Float.valueOf(0.06f)).setDescription("chance every tick of spawning a snowman in the radius of the ritual (the higher the value is the lower the chance becomes) [default: 1/150]");
    public int interval_heal;
    public int radius_x;
    public int radius_y;
    public int radius_z;
    public float interval_spawn;

    public RitualFrostLands(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_INTERVAL_HEAL, PROP_INTERVAL_SPAWN);
        this.setEntityClass(EntityRitualFrostLands.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new OreIngredient("sugarcane"), new ItemStack(ModItems.dewgonia), new OreIngredient("vine"), new ItemStack(ModItems.bark_spruce), new ItemStack(ModItems.bark_spruce));
        this.setIcon(ModItems.ritual_frost_lands);
        this.setColor(TextFormatting.AQUA);
        this.setBold(true);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        int[] radius = this.properties.getRadius();
        this.radius_x = radius[0];
        this.radius_y = radius[1];
        this.radius_z = radius[2];
        this.interval_heal = this.properties.get(PROP_INTERVAL_HEAL);
        this.interval_spawn = this.properties.get(PROP_INTERVAL_SPAWN).floatValue();
    }
}

