/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.entity.ritual.EntityRitualFireStorm;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.conditions.ConditionStandingStones;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.TextFormatting;

public class RitualFireStorm
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(600);
    public static Property<Integer> PROP_PROJECTILE_COUNT = new Property<Integer>("projectile_count", 40).setDescription("maximum number of projectiles flare entities present during the ritual (checked every 2 ticks)");
    public static Property<Float> PROP_PROJECTILE_DAMAGE = new Property<Float>("projectile_damage", Float.valueOf(4.0f)).setDescription("damage dealt to hostile entities by each ritual projectile");
    public static Property<Float> PROP_PROJECTILE_KNOCKBACK = new Property<Float>("projectile_knockback", Float.valueOf(0.5f)).setDescription("knockback dealt to hostile entities by each ritual projectile");
    public float projectile_damage;
    public float projectile_knockback;
    public int projectile_count;

    public RitualFireStorm(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_PROJECTILE_COUNT, PROP_PROJECTILE_DAMAGE, PROP_PROJECTILE_KNOCKBACK);
        this.setEntityClass(EntityRitualFireStorm.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new ItemStack(ModItems.infernal_bulb), new ItemStack(ModItems.bark_acacia), Ingredient.func_193367_a((Item)Items.field_151044_h), new ItemStack(ModItems.bark_acacia), new ItemStack(Items.field_151065_br));
        this.addCondition(new ConditionStandingStones(3, 1));
        this.addCondition(new ConditionStandingStones(4, 3));
        this.setIcon(ModItems.ritual_fire_storm);
        this.setColor(TextFormatting.RED);
        this.setBold(true);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        this.projectile_damage = this.properties.get(PROP_PROJECTILE_DAMAGE).floatValue();
        this.projectile_count = this.properties.get(PROP_PROJECTILE_COUNT);
        this.projectile_knockback = this.properties.get(PROP_PROJECTILE_KNOCKBACK).floatValue();
    }
}

