/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.Roots;
import epicsquid.roots.block.BlockPyre;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.properties.PropertyTable;
import epicsquid.roots.recipe.IRootsRecipe;
import epicsquid.roots.ritual.conditions.ICondition;
import epicsquid.roots.tileentity.TileEntityPyre;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class RitualBase {
    protected static Random random = new Random();
    protected PropertyTable properties = new PropertyTable();
    private Class<? extends EntityRitualBase> entityClass;
    private List<ICondition> conditions = new ArrayList<ICondition>();
    private Item icon;
    private ItemStack stack = ItemStack.field_190927_a;
    private String name;
    private TextFormatting color;
    private boolean bold;
    public RitualRecipe recipe = RitualRecipe.EMPTY;
    protected int duration;
    protected boolean disabled;
    private boolean finalised;

    public RitualBase(String name, boolean disabled) {
        this.name = name;
        this.disabled = disabled;
        this.duration = 0;
    }

    public void setRecipe(RitualRecipe recipe) {
        this.recipe = recipe;
    }

    public Class<? extends EntityRitualBase> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<? extends EntityRitualBase> entityClass) {
        this.entityClass = entityClass;
    }

    public String getFormat() {
        String format = this.color + "";
        if (this.bold) {
            format = format + TextFormatting.BOLD;
        }
        return format;
    }

    public void setColor(TextFormatting color) {
        this.color = color;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public Item getIcon() {
        return this.icon;
    }

    public ItemStack getItemStack() {
        if (this.stack.func_190926_b()) {
            this.stack = new ItemStack(this.icon);
        }
        return this.stack;
    }

    public void setIcon(Item icon) {
        this.icon = icon;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public List<ICondition> getConditions() {
        return this.conditions;
    }

    public void addCondition(ICondition condition) {
        this.conditions.add(condition);
    }

    public boolean isRitualRecipe(TileEntityPyre tileEntityPyre, @Nullable EntityPlayer player) {
        if (this.isDisabled()) {
            return false;
        }
        return this.recipe.matches(tileEntityPyre, player);
    }

    public boolean canFire(TileEntityPyre Pyre, @Nullable EntityPlayer player, boolean refire) {
        IBlockState state;
        if (!refire && ((Boolean)(state = Pyre.func_145831_w().func_180495_p(Pyre.func_174877_v())).func_177229_b((IProperty)BlockPyre.BURNING)).booleanValue()) {
            return false;
        }
        return this.checkTileConditions(Pyre, player);
    }

    private boolean checkTileConditions(TileEntityPyre tileEntityPyre, @Nullable EntityPlayer player) {
        boolean success = true;
        for (ICondition condition : this.conditions) {
            if (condition.check(tileEntityPyre, player)) continue;
            success = false;
        }
        return success;
    }

    @Nullable
    public EntityRitualBase doEffect(World world, BlockPos pos, @Nullable EntityPlayer player) {
        return this.spawnEntity(world, pos, this.getEntityClass(), player);
    }

    @Nullable
    protected EntityRitualBase spawnEntity(World world, BlockPos pos, Class<? extends EntityRitualBase> entity, @Nullable EntityPlayer player) {
        List pastRituals = world.func_72872_a(entity, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 100), (double)(pos.func_177952_p() + 1)));
        pastRituals.removeIf(o -> !o.getClass().equals(entity));
        if (pastRituals.size() == 0 && !world.field_72995_K) {
            EntityRitualBase ritual = null;
            try {
                Constructor<? extends EntityRitualBase> cons = entity.getDeclaredConstructor(World.class);
                ritual = cons.newInstance(world);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (ritual == null) {
                return null;
            }
            ritual.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            if (player != null) {
                ritual.setPlayer(player.func_110124_au());
            }
            world.func_72838_d((Entity)ritual);
            return ritual;
        }
        if (pastRituals.size() > 0) {
            for (EntityRitualBase ritual : pastRituals) {
                if (!ritual.getClass().equals(entity)) continue;
                ritual.func_184212_Q().func_187227_b(EntityRitualBase.lifetime, (Object)(this.getDuration() + 20));
                ritual.func_184212_Q().func_187217_b(EntityRitualBase.lifetime);
            }
            return (EntityRitualBase)pastRituals.get(0);
        }
        return null;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getName() {
        return this.name;
    }

    public abstract void init();

    public List<Ingredient> getIngredients() {
        return this.recipe.getIngredients();
    }

    public void finalise() {
        this.doFinalise();
        this.validateProperties();
        this.finalised = true;
    }

    public abstract void doFinalise();

    public void validateProperties() {
        List<String> values = this.properties.finalise();
        if (!values.isEmpty()) {
            StringJoiner join = new StringJoiner(",");
            values.forEach(join::add);
            Roots.logger.error("Ritual '" + this.name + "' property table has the following keys inserted but not fetched: |" + join.toString() + "|");
        }
    }

    public boolean finalised() {
        return this.finalised;
    }

    public PropertyTable getProperties() {
        return this.properties;
    }

    public AxisAlignedBB getBoundingBox() {
        if (this.properties.hasProperty("radius_x") && this.properties.hasProperty("radius_y") && this.properties.hasProperty("radius_z")) {
            int x = (Integer)this.properties.getValue("radius_x");
            int y = (Integer)this.properties.getValue("radius_y");
            int z = (Integer)this.properties.getValue("radius_z");
            return new AxisAlignedBB((double)(-x), (double)(-y), (double)(-z), (double)x, (double)y, (double)z);
        }
        return null;
    }

    public static class RitualRecipe
    implements IRootsRecipe<TileEntityPyre> {
        public static RitualRecipe EMPTY = new RitualRecipe(null, Collections.emptyList());
        public List<Ingredient> ingredients;
        public RitualBase ritual;

        public RitualRecipe(RitualBase ritual) {
            this.ritual = ritual;
        }

        public RitualRecipe(RitualBase ritual, List<Ingredient> ingredients) {
            this.ingredients = ingredients;
            this.ritual = ritual;
        }

        public RitualRecipe(RitualBase ritual, Object ... stacks) {
            this.ingredients = new ArrayList<Ingredient>();
            for (Object stack : stacks) {
                if (stack instanceof Ingredient) {
                    this.ingredients.add((Ingredient)stack);
                    continue;
                }
                if (!(stack instanceof ItemStack)) continue;
                this.ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)stack}));
            }
            this.ritual = ritual;
        }

        @Override
        public List<Ingredient> getIngredients() {
            return this.ingredients;
        }

        public boolean matches(TileEntityPyre tile, @Nullable EntityPlayer player) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < tile.inventory.getSlots(); ++i) {
                stacks.add(tile.inventory.extractItem(i, 1, true));
            }
            return this.matches(stacks);
        }
    }
}

