/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.entity.ritual.EntityRitualAnimalHarvest;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.conditions.ConditionStandingStones;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class RitualAnimalHarvest
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(3200);
    public static Property.PropertyInterval PROP_INTERVAL = new Property.PropertyInterval(110).setDescription("the number of ticks between each ritual harvest");
    public static Property<Integer> PROP_COUNT = new Property<Integer>("count", 5).setDescription("the number of times harvesting will be performed per interval");
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 15).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 10).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 15).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_GLOW_DURATION = new Property<Integer>("glowing", 30).setDescription("duration (in ticks) mobs will glow after being harvested");
    public static Property<Float> PROP_LOOTING_CHANCE = new Property<Float>("looting_chance", Float.valueOf(0.16f)).setDescription("chance per operation that the the looting chance will be set to looting_value");
    public static Property<Integer> PROP_LOOTING_VALUE = new Property<Integer>("looting_value", 1).setDescription("the value passed to the loot function for 'looting' if looting_chance was successful");
    public static Property<Float> PROP_FISH_CHANCE = new Property<Float>("fish_chance", Float.valueOf(0.2f)).setDescription("chance per operation that, if suitable water source blocks are found, fish will be produced instead of animal drops being produced");
    public static Property<Integer> PROP_FISH_COUNT = new Property<Integer>("fish_count", 3).setDescription("number of fish that are guaranteed to drop");
    public static Property<Integer> PROP_FISH_ADDITIONAL = new Property<Integer>("fish_additional", 3).setDescription("additional fish (random 0-X)-2 that are produced if fish are produced");
    public int interval;
    public int count;
    public int radius_x;
    public int radius_y;
    public int radius_z;
    public int looting_value;
    public int glowing;
    public int fish_additional;
    public int fish_count;
    public float fish_chance;
    public float looting_chance;

    public RitualAnimalHarvest(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_INTERVAL, PROP_COUNT, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_LOOTING_CHANCE, PROP_LOOTING_VALUE, PROP_GLOW_DURATION, PROP_FISH_CHANCE, PROP_FISH_COUNT, PROP_FISH_ADDITIONAL);
        this.setEntityClass(EntityRitualAnimalHarvest.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new ItemStack(ModItems.wildewheet), new OreIngredient("wool"), new OreIngredient("cropCarrot"), new OreIngredient("slimeball"), new OreIngredient("wildroot"));
        this.addCondition(new ConditionStandingStones(3, 3));
        this.setIcon(ModItems.ritual_animal_harvest);
        this.setColor(TextFormatting.GOLD);
        this.setBold(true);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        this.interval = this.properties.get(PROP_INTERVAL);
        int[] radius = this.properties.getRadius();
        this.radius_x = radius[0];
        this.radius_y = radius[1];
        this.radius_z = radius[2];
        this.looting_chance = this.properties.get(PROP_LOOTING_CHANCE).floatValue();
        this.looting_value = this.properties.get(PROP_LOOTING_VALUE);
        this.glowing = this.properties.get(PROP_GLOW_DURATION);
        this.fish_chance = this.properties.get(PROP_FISH_CHANCE).floatValue();
        this.fish_count = this.properties.get(PROP_FISH_COUNT);
        this.fish_additional = this.properties.get(PROP_FISH_ADDITIONAL);
        this.count = this.properties.get(PROP_COUNT);
    }
}

