/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.recipe;

import epicsquid.mysticallib.types.OneTimeSupplier;
import epicsquid.mysticallib.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.oredict.OreIngredient;

public class FoodPoisoning {
    private static List<OreToStack> items = new ArrayList<OreToStack>();

    public static void addPoison(String oreName, ItemStack stack, float chance) {
        items.add(new OreToStack(oreName, stack, chance));
    }

    public static ItemStack replacement(ItemStack input) {
        for (OreToStack o : items) {
            if (!o.test(input)) continue;
            return o.result();
        }
        return input;
    }

    static {
        FoodPoisoning.addPoison("cropPotato", new ItemStack(Items.field_151170_bI), 0.18f);
    }

    public static class OreToStack
    implements Predicate<ItemStack> {
        private final Supplier<Ingredient> input;
        private final ItemStack stack;
        private final String oreName;
        private final float chance;

        public OreToStack(String oreName, ItemStack stack, float chance) {
            this.oreName = oreName;
            this.input = new OneTimeSupplier(() -> new OreIngredient(oreName));
            this.stack = stack;
            this.chance = chance;
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.input.get().apply(stack) && Util.rand.nextFloat() <= this.chance;
        }

        public ItemStack result() {
            return this.stack.func_77946_l();
        }

        public String oreName() {
            return this.oreName;
        }
    }
}

