/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.particle;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.MysticalLib;
import epicsquid.mysticallib.proxy.ClientProxy;
import epicsquid.mysticallib.util.RayCastUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.ModParticles;
import epicsquid.roots.spell.SpellBase;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ParticleUtil {
    public static Random random = new Random();
    public static int counter = 0;

    public static void spawnParticleRain(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, LibRegistry.PARTICLE_RAIN, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, a, scale, 1.0});
        }
    }

    public static void spawnParticleStar(World world, float x, float y, float z, float vx, float vy, float vz, float[] rgba, float scale, int lifetime) {
        ParticleUtil.spawnParticleStar(world, x, y, z, vx, vy, vz, rgba[0], rgba[1], rgba[2], rgba[3], scale, lifetime);
    }

    public static void spawnParticleStar(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, ModParticles.PARTICLE_STAR, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, r, g, b, a, scale, 1.0});
        }
    }

    public static void spawnParticleStarNoGravity(World world, float x, float y, float z, float vx, float vy, float vz, float[] rgba, float scale, int lifetime) {
        ParticleUtil.spawnParticleStarNoGravity(world, x, y, z, vx, vy, vz, rgba[0], rgba[1], rgba[2], rgba[3], scale, lifetime);
    }

    public static void spawnParticleStarNoGravity(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, ModParticles.PARTICLE_STAR_NO_GRAVITY, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, r, g, b, a, scale, 1.0});
        }
    }

    public static void spawnParticleFiery(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, LibRegistry.PARTICLE_FLAME, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, r, g, b, a, scale});
        }
    }

    public static void spawnParticleFiery(World world, float x, float y, float z, float vx, float vy, float vz, float[] rgba, float scale, int lifetime) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, LibRegistry.PARTICLE_FLAME, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, rgba[0], rgba[1], rgba[2], rgba[3], scale});
        }
    }

    public static void spawnParticleLineGlow(World world, float x, float y, float z, float vx, float vy, float vz, float[] rgba, float scale, int lifetime) {
        ParticleUtil.spawnParticleLineGlow(world, x, y, z, vx, vy, vz, rgba[0], rgba[1], rgba[2], rgba[3], scale, lifetime);
    }

    public static void spawnParticleLineGlow(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, ModParticles.PARTICLE_LINE_GLOW, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, r, g, b, a, scale});
        }
    }

    public static void spawnParticleLineGlowSteady(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, ModParticles.PARTICLE_LINE_GLOW_STEADY, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, r, g, b, a, scale});
        }
    }

    public static void spawnParticleSmoke(World world, float x, float y, float z, float vx, float vy, float vz, float[] rgba, float scale, int lifetime, boolean additive) {
        ParticleUtil.spawnParticleSmoke(world, x, y, z, vx, vy, vz, rgba[0], rgba[1], rgba[2], rgba[3], scale, lifetime, additive);
    }

    public static void spawnParticleSmoke(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime, boolean additive) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, LibRegistry.PARTICLE_SMOKE, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, r, g, b, a, scale, 1.0});
        }
    }

    public static void spawnParticleCloud(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime, boolean additive) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, LibRegistry.PARTICLE_CLOUD, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, r, g, b, a, scale, 1.0});
        }
    }

    public static void spawnParticleGlow(World world, float x, float y, float z, float vx, float vy, float vz, float[] rgba, float scale, int lifetime) {
        ParticleUtil.spawnParticleGlow(world, x, y, z, vx, vy, vz, rgba[0], rgba[1], rgba[2], rgba[3], scale, lifetime);
    }

    public static void spawnParticleGlow(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, LibRegistry.PARTICLE_GLOW, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, r, g, b, a, scale});
        }
    }

    public static void spawnParticleSpark(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, LibRegistry.PARTICLE_SPARK, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, r, g, b, a, scale, lifetime});
        }
    }

    public static void spawnParticleThorn(World world, float x, float y, float z, float vx, float vy, float vz, float[] rgba, float scale, int lifetime, boolean additive) {
        ParticleUtil.spawnParticleThorn(world, x, y, z, vx, vy, vz, rgba[0], rgba[1], rgba[2], rgba[3], scale, lifetime, additive);
    }

    public static void spawnParticleThorn(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime, boolean additive) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, ModParticles.PARTICLE_THORN, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, r, g, b, a, scale});
        }
    }

    public static void spawnParticlePetal(World world, float x, float y, float z, float vx, float vy, float vz, float[] rgba, float scale, int lifetime) {
        ParticleUtil.spawnParticlePetal(world, x, y, z, vz, vy, vz, rgba[0], rgba[1], rgba[2], rgba[3], scale, lifetime);
    }

    public static void spawnParticlePetal(World world, float x, float y, float z, float vx, float vy, float vz, float[] rgba, float scale, int lifetime, boolean nodepth) {
        ParticleUtil.spawnParticlePetal(world, x, y, z, vz, vy, vz, rgba[0], rgba[1], rgba[2], rgba[3], scale, lifetime, nodepth);
    }

    public static void spawnParticlePetal(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime) {
        ParticleUtil.spawnParticleSmoke(world, x, y, z, vx, vy, vz, r, g, b, a, scale, lifetime, false);
    }

    public static void spawnParticlePetal(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime, boolean noDepth) {
        if (MysticalLib.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.spawnParticle(world, noDepth ? ModParticles.PARTICLE_PETAL_NO_DEPTH : ModParticles.PARTICLE_PETAL, (double)x, (double)y, (double)z, (double)vx, (double)vy, (double)vz, new double[]{lifetime, r, g, b, a, scale});
        }
    }

    public static void renderBeam(EntityPlayer player, double distance, ParticleSpawner spawner, SpellBase colors) {
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        List positions = RayCastUtil.rayTraceEntitiesPositions((Entity)player, (double)distance);
        ParticleUtil.renderBeam(player.field_70170_p, (Vec3d)positions.get(0), (Vec3d)positions.get(1), spawner, colors);
    }

    public static void renderBeam(World world, Vec3d startPosition, Vec3d stopPosition, ParticleSpawner spawner, SpellBase colors) {
        double dist = stopPosition.func_178788_d(startPosition).func_72433_c();
        double alphaDist = 0.0;
        for (double j = 0.0; j < dist; j += 0.15) {
            double x = startPosition.field_72450_a * (1.0 - j / dist) + stopPosition.field_72450_a * (j / dist);
            double y = startPosition.field_72448_b * (1.0 - j / dist) + stopPosition.field_72448_b * (j / dist);
            double z = startPosition.field_72449_c * (1.0 - j / dist) + stopPosition.field_72449_c * (j / dist);
            alphaDist += 0.15;
            if (Util.rand.nextBoolean()) {
                spawner.spawn(world, (float)x, (float)y, (float)z, 0.0f, 0.0f, 0.0f, colors.getFirstColours(0.75f * (float)(1.0 - alphaDist / dist)), 3.0f + 3.0f * Util.rand.nextFloat(), 30);
                continue;
            }
            spawner.spawn(world, (float)x, (float)y, (float)z, 0.0f, 0.0f, 0.0f, colors.getSecondColours(0.75f * (float)(1.0 - alphaDist / dist)), 3.0f + 3.0f * Util.rand.nextFloat(), 30);
        }
    }

    @FunctionalInterface
    public static interface ParticleSpawner {
        public void spawn(World var1, float var2, float var3, float var4, float var5, float var6, float var7, float[] var8, float var9, int var10);
    }
}

