/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network.fx;

import epicsquid.roots.network.ClientMessageHandler;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.SpellGeas;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageGeasFX
implements IMessage {
    private static Random random = new Random();
    private double posX = 0.0;
    private double posY = 0.0;
    private double posZ = 0.0;

    public MessageGeasFX() {
    }

    public MessageGeasFX(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public static float getColorCycle(float ticks) {
        return (MathHelper.func_76126_a((float)((float)Math.toRadians(ticks))) + 1.0f) / 2.0f;
    }

    public static class MessageHolder
    extends ClientMessageHandler<MessageGeasFX> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handleMessage(MessageGeasFX message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            for (float i = 0.0f; i < 360.0f; i += (float)random.nextInt(40)) {
                double yaw = Math.toRadians(i);
                float x = (float)message.posX + 0.25f * random.nextFloat() * (float)Math.sin(yaw);
                float y = (float)message.posY;
                float z = (float)message.posZ + 0.25f * random.nextFloat() * (float)Math.cos(yaw);
                if (random.nextBoolean()) {
                    ParticleUtil.spawnParticleGlow((World)world, x, y, z, 0.0f, 0.125f * (random.nextFloat() - 0.5f), 0.0f, SpellGeas.instance.getFirstColours(0.75f), 2.0f + random.nextFloat() * 2.0f, 20);
                    continue;
                }
                ParticleUtil.spawnParticleGlow((World)world, x, y, z, 0.0f, 0.125f * (random.nextFloat() - 0.5f), 0.0f, SpellGeas.instance.getSecondColours(0.75f), 2.0f + random.nextFloat() * 2.0f, 20);
            }
        }
    }
}

