/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.modifiers;

import epicsquid.roots.Roots;
import epicsquid.roots.modifiers.IModifier;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class ModifierRegistry {
    private static final Map<ResourceLocation, Modifier> map = new HashMap<ResourceLocation, Modifier>();
    private static final Set<ResourceLocation> disabledModifiers = new HashSet<ResourceLocation>();

    @Nullable
    public static Modifier get(Modifier modifier) {
        if (modifier == null) {
            return null;
        }
        return map.get(modifier.getRegistryName());
    }

    @Nullable
    public static Modifier get(ResourceLocation name) {
        return map.get(name);
    }

    public static void disable(IModifier modifier) {
        if (modifier == null) {
            return;
        }
        disabledModifiers.add(modifier.getRegistryName());
    }

    public static boolean isDisabled(IModifier modifier) {
        if (modifier == null) {
            return false;
        }
        return disabledModifiers.contains(modifier.getRegistryName());
    }

    public static Modifier register(Modifier modifier) {
        ResourceLocation registryName = modifier.getRegistryName();
        if (registryName == null) {
            throw new IllegalStateException("Modifier being registered has a null registry name.");
        }
        if (map.containsKey(registryName)) {
            throw new IllegalStateException("Modifier with registry name " + registryName + " already exists!");
        }
        map.put(registryName, modifier);
        return modifier;
    }

    public static Collection<Modifier> getModifiers() {
        return map.values();
    }

    @Nullable
    public static Modifier fromHashCode(int code) {
        for (Map.Entry<ResourceLocation, Modifier> entry : map.entrySet()) {
            if (entry.getKey().hashCode() == code) {
                return entry.getValue();
            }
            Roots.logger.info("Modifier " + entry.getKey() + " hash code is: " + entry.getKey().hashCode());
        }
        return null;
    }

    @Nullable
    public static SpellBase getSpellFromModifier(Modifier mod) {
        for (SpellBase spell : SpellRegistry.getSpells()) {
            if (!spell.acceptsModifiers(mod)) continue;
            return spell;
        }
        return null;
    }
}

