/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.mechanics;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.config.SpellConfig;
import epicsquid.roots.integration.botania.SolegnoliaHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class Magnetize {
    public static <T extends Entity> List<T> collect(Class<? extends T> clazz, World world, BlockPos startPosition, int radiusX, int radiusY, int radiusZ) {
        List entities = Util.getEntitiesWithinRadius((World)world, clazz, (BlockPos)startPosition, (float)radiusX, (float)radiusY, (float)radiusZ);
        entities.removeIf(Magnetize::skipPull);
        return entities;
    }

    public static <T extends Entity> int pull(Class<? extends T> clazz, World world, BlockPos startPosition, int radiusX, int radiusY, int radiusZ) {
        List<Entity> entities = Magnetize.collect(clazz, world, startPosition, radiusX, radiusY, radiusZ);
        if (entities.isEmpty()) {
            return 0;
        }
        for (Entity entity : entities) {
            if (world.field_72995_K) continue;
            if (entity instanceof EntityItem && !entity.field_70128_L) {
                ((EntityItem)entity).func_174867_a(0);
            }
            entity.func_174828_a(startPosition, 0.0f, 0.0f);
        }
        return entities.size();
    }

    public static List<BlockPos> store(World world, BlockPos startPosition, IItemHandler handler, int radiusX, int radiusY, int radiusZ) {
        List<EntityItem> items = Magnetize.collect(EntityItem.class, world, startPosition, radiusX, radiusY, radiusZ);
        Iterator<EntityItem> iterator = items.iterator();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        while (iterator.hasNext()) {
            EntityItem entity = iterator.next();
            ItemStack item = entity.func_92059_d();
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)item, (boolean)false);
            positions.add(entity.func_180425_c());
            if (result.func_190926_b()) {
                entity.func_70106_y();
                continue;
            }
            entity.func_92058_a(result);
        }
        return positions;
    }

    public static boolean skipPull(Entity entity) {
        if (entity.field_70128_L) {
            return true;
        }
        if (entity instanceof EntityItem && entity.getEntityData().func_74764_b("PreventRemoteMovement")) {
            return true;
        }
        if (!SpellConfig.spellFeaturesCategory.shouldMagnetismAttractXP && entity instanceof EntityXPOrb) {
            return true;
        }
        return SolegnoliaHelper.hasBotania() && SolegnoliaHelper.hasSolegnoliaAround(entity);
    }
}

