/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemKnifeBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.config.MossConfig;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.item.dispenser.DispenseKnife;
import epicsquid.roots.util.RitualUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDruidKnife
extends ItemKnifeBase {
    public ItemDruidKnife(String name, Item.ToolMaterial material) {
        super(name, material, () -> Ingredient.field_193370_a);
        ModItems.knives.add((Item)this);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DispenseKnife.getInstance());
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            IBlockState result;
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if ((player.func_70093_af() && block == ModBlocks.reinforced_pyre || block == ModBlocks.pyre) && block.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ)) {
                return EnumActionResult.SUCCESS;
            }
            if (!MossConfig.getBlacklistDimensions().contains(world.field_73011_w.getDimension()) && (result = MossConfig.scrapeResult(state)) != null) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, result);
                    world.func_180497_b(pos, result.func_177230_c(), 1, result.func_177230_c().func_149738_a(world));
                    ItemUtil.spawnItem((World)world, (BlockPos)player.func_180425_c().func_177982_a(0, 1, 0), (ItemStack)new ItemStack(ModItems.terra_moss));
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                    }
                }
                world.func_184133_a(player, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return EnumActionResult.SUCCESS;
            }
            result = RitualUtil.RunedWoodType.matchesAny(state);
            ItemStack offHand = player.func_184592_cb();
            if (result != null && offHand.func_77973_b() == ModItems.wildroot) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, result);
                    world.func_180497_b(pos, result.func_177230_c(), 1, result.func_177230_c().func_149738_a(world));
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                        offHand.func_190918_g(1);
                        player.func_184611_a(EnumHand.OFF_HAND, offHand.func_190926_b() ? ItemStack.field_190927_a : offHand);
                    }
                    world.func_184133_a(null, pos, SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add("");
        tooltip.add(I18n.func_135052_a((String)"roots.tooltip.knife1", (Object[])new Object[]{TextFormatting.GOLD + I18n.func_135052_a((String)"roots.tooltip.logs", (Object[])new Object[0]) + TextFormatting.RESET, TextFormatting.GOLD + I18n.func_135052_a((String)"roots.tooltip.bark", (Object[])new Object[0]) + TextFormatting.RESET}));
        tooltip.add(I18n.func_135052_a((String)"roots.tooltip.knife2", (Object[])new Object[]{TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"roots.tooltip.eligible", (Object[])new Object[0]) + TextFormatting.RESET, TextFormatting.GREEN + "" + TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.terra_moss", (Object[])new Object[0]) + TextFormatting.RESET}));
        if (ItemUtil.shouldDisplayMore((ItemStack)stack, (World)worldIn, tooltip, (ITooltipFlag)flagIn, (String)"roots.tooltip.shift", (TextFormatting)TextFormatting.DARK_GRAY)) {
            tooltip.add(I18n.func_135052_a((String)"roots.tooltip.knife_dispenser", (Object[])new Object[0]));
        }
    }
}

