/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.tweaks;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.integration.crafttweaker.Action;
import epicsquid.roots.integration.crafttweaker.tweaks.predicates.Predicates;
import epicsquid.roots.recipe.TransmutationRecipe;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.Transmutation")
@ZenDocAppend(value={"docs/include/transmutation.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.Transmutation")
public class TransmutationTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="the name of the recipe being removed")}, description={"Specifically removes a Transmutation Recipe based on the name of that recipe."})
    @ZenMethod
    public static void removeRecipe(String name) {
        CraftTweaker.LATE_ACTIONS.add(new Remove(name));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="name", info="the name of the recipe being created"), @ZenDocArg(arg="start", info="the predicate describing the starting state being converted"), @ZenDocArg(arg="result", info="the block state to convert to"), @ZenDocArg(arg="condition", info="the condition of this transition (can be null)")}, description={"Add a Transmutation Recipe that converts from one IPredicate state-predicate into a block state, if the IWorldPredicate condition (which can be null, meaning that it will always match) is true."})
    @ZenMethod
    public static void addStateToStateRecipe(String name, Predicates.IPredicate start, IBlockState result, @Nullable Predicates.IWorldPredicate condition) {
        CraftTweaker.LATE_ACTIONS.add(new AddStateToState(name, start, result, condition));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="name", info="the name of the recipe being created"), @ZenDocArg(arg="start", info="the predicate describing the starting state being converted"), @ZenDocArg(arg="result", info="the item stack to convert to"), @ZenDocArg(arg="condition", info="the condition of this transition (can be null)")}, description={"Add a Transmutation Recipe that converts from one IPredicate state-predicate into an item, if the IWorldPredicate condition (which can be null, meaning that it will always match) is true."})
    @ZenMethod
    public static void addStateToItemRecipe(String name, Predicates.IPredicate start, IItemStack result, @Nullable Predicates.IWorldPredicate condition) {
        CraftTweaker.LATE_ACTIONS.add(new AddStateToItem(name, start, result, condition));
    }

    private static class Remove
    extends Action {
        private final ResourceLocation name;

        public Remove(String name) {
            super("remove_transmutation");
            this.name = name.contains(":") ? new ResourceLocation(name) : new ResourceLocation("roots", name);
        }

        public void apply() {
            if (!ModRecipes.removeTransmutationRecipe(this.name)) {
                CraftTweakerAPI.logError((String)("Unable to remove Transmutation recipe " + this.name + " as it doesn't exist."));
            }
        }

        public String describe() {
            return String.format("Recipe to remove %s from Transmutation", this.name);
        }
    }

    private static class AddStateToItem
    extends Action {
        private final ResourceLocation name;
        private Predicates.IPredicate start;
        private IItemStack result;
        private Predicates.IWorldPredicate condition;

        public AddStateToItem(String name, Predicates.IPredicate start, IItemStack result, Predicates.IWorldPredicate condition) {
            super("AddStateToItem");
            this.name = new ResourceLocation("roots", name);
            this.start = start;
            this.result = result;
            this.condition = condition;
        }

        public void apply() {
            TransmutationRecipe recipe = new TransmutationRecipe(this.start.get()).item(CraftTweakerMC.getItemStack((IItemStack)this.result)).condition(this.condition == null ? null : this.condition.get());
            recipe.setRegistryName(this.name);
            ModRecipes.addTransmutationRecipe(recipe);
        }

        public String describe() {
            return "Add a State-to-Item conversion recipe, resulting state: " + this.result.toString();
        }
    }

    private static class AddStateToState
    extends Action {
        private final ResourceLocation name;
        private Predicates.IPredicate start;
        private IBlockState result;
        private Predicates.IWorldPredicate condition;

        public AddStateToState(String name, Predicates.IPredicate start, IBlockState result, Predicates.IWorldPredicate condition) {
            super("AddStateToState");
            this.name = new ResourceLocation("roots", name);
            this.start = start;
            this.result = result;
            this.condition = condition;
        }

        public void apply() {
            TransmutationRecipe recipe = new TransmutationRecipe(this.start.get()).state(CraftTweakerMC.getBlockState((IBlockState)this.result)).condition(this.condition == null ? null : this.condition.get());
            recipe.setRegistryName(this.name);
            ModRecipes.addTransmutationRecipe(recipe);
        }

        public String describe() {
            return "Add a State-to-State conversion recipe, resulting state: " + this.result.toString();
        }
    }
}

