/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.ritual;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.Roots;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.item.ItemLifeEssence;
import epicsquid.roots.network.fx.MessageCreatureSummonedFX;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.recipe.SummonCreatureRecipe;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.ritual.RitualSummonCreatures;
import epicsquid.roots.util.RitualUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityRitualSummonCreatures
extends EntityRitualBase {
    private RitualSummonCreatures ritual;
    private SummonCreatureRecipe summonRecipe = null;
    private ItemStack essence = ItemStack.field_190927_a;

    public EntityRitualSummonCreatures(World worldIn) {
        super(worldIn);
        this.func_184212_Q().func_187214_a(lifetime, (Object)(RitualRegistry.ritual_summon_creatures.getDuration() + 20));
        this.ritual = (RitualSummonCreatures)RitualRegistry.ritual_summon_creatures;
    }

    public void setSummonRecipe(SummonCreatureRecipe summonRecipe) {
        this.summonRecipe = summonRecipe;
    }

    public void setEssence(ItemStack essence) {
        this.essence = essence;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        float alpha = (float)Math.min(40, RitualRegistry.ritual_summon_creatures.getDuration() + 20 - (Integer)this.func_184212_Q().func_187225_a(lifetime)) / 40.0f;
        if (this.field_70170_p.field_72995_K && (Integer)this.func_184212_Q().func_187225_a(lifetime) > 0) {
            for (float i = 0.0f; i < 360.0f; i += this.field_70146_Z.nextFloat() * 90.0f) {
                float vx = -(0.09f * (float)Math.sin(Math.toRadians(i)));
                float vz = -(0.09f * (float)Math.cos(Math.toRadians(i)));
                float tx = (float)this.field_70165_t + 2.5f * (float)Math.sin(Math.toRadians(i));
                float ty = (float)this.field_70163_u;
                float tz = (float)this.field_70161_v + 2.5f * (float)Math.cos(Math.toRadians(i));
                ParticleUtil.spawnParticleSmoke(this.field_70170_p, tx, ty, tz, vx, 0.0f, vz, 67.0f, 0.0f, 87.0f, 0.065f * alpha, 5.0f, 125, true);
            }
        }
        if (this.field_70173_aa % this.ritual.interval == 0 && !this.field_70170_p.field_72995_K) {
            Class<? extends EntityLivingBase> entityClass = null;
            if (this.summonRecipe != null) {
                entityClass = this.summonRecipe.getClazz();
            } else if (!this.essence.func_190926_b()) {
                entityClass = ((ItemLifeEssence)ModItems.life_essence).getEntityClass(this.essence);
            }
            Entity entity = null;
            if (entityClass != null) {
                try {
                    Constructor<? extends EntityLivingBase> constructor = entityClass.getDeclaredConstructor(World.class);
                    entity = (Entity)constructor.newInstance(this.field_70170_p);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    Roots.logger.error("Unable to summon entity of class " + entityClass.toString(), (Throwable)e);
                }
            }
            if (entity == null) {
                return;
            }
            BlockPos suitable = BlockPos.field_177992_a;
            for (int i = 0; i < this.ritual.tries; ++i) {
                BlockPos solid = suitable = RitualUtil.getRandomPosRadialXZ(this.func_180425_c(), this.ritual.radius_x, this.ritual.radius_z);
                while (this.field_70170_p.func_175623_d(solid) || !this.field_70170_p.isSideSolid(solid, EnumFacing.UP)) {
                    solid = solid.func_177977_b();
                }
                if (suitable == solid) {
                    while (!this.field_70170_p.func_175623_d(suitable)) {
                        suitable = suitable.func_177984_a();
                    }
                }
                if (this.field_70170_p.func_175623_d(suitable) && !this.field_70170_p.func_175623_d(solid)) break;
                suitable = BlockPos.field_177992_a;
            }
            if (suitable == BlockPos.field_177992_a) {
                return;
            }
            entity.func_70107_b((double)suitable.func_177958_n() + 0.5, (double)suitable.func_177956_o() + 0.5, (double)suitable.func_177952_p() + 0.5);
            this.field_70170_p.func_72838_d(entity);
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_188423_x, this.ritual.glow_duration));
            }
            PacketHandler.sendToAllTracking((IMessage)new MessageCreatureSummonedFX(entity), (Entity)entity);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("summonRecipe")) {
            this.summonRecipe = ModRecipes.getSummonCreatureEntry(new ResourceLocation(compound.func_74779_i("summonRecipe")));
        }
        this.essence = new ItemStack(compound.func_74775_l("essence"));
        super.func_70037_a(compound);
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        if (this.summonRecipe != null) {
            compound.func_74778_a("summonRecipe", this.summonRecipe.getRegistryName().toString());
        }
        compound.func_74782_a("essence", (NBTBase)this.essence.serializeNBT());
        super.func_70014_b(compound);
    }
}

