/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.ritual;

import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.ritual.RitualHeavyStorms;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.util.RitualUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class EntityRitualHeavyStorms
extends EntityRitualBase {
    private RitualHeavyStorms ritual;
    private int strike_count = 0;

    public EntityRitualHeavyStorms(World worldIn) {
        super(worldIn);
        this.func_184212_Q().func_187214_a(lifetime, (Object)(RitualRegistry.ritual_heavy_storms.getDuration() + 20));
        this.ritual = (RitualHeavyStorms)RitualRegistry.ritual_heavy_storms;
    }

    @Nullable
    public BlockPos validPosition() {
        if (this.field_70170_p.field_72995_K) {
            return BlockPos.field_177992_a;
        }
        BlockPos pos = this.func_180425_c();
        int maxY = (int)((double)pos.func_177956_o() + this.ritual.radius_x);
        for (int i = 0; i < 500; ++i) {
            BlockPos random = RitualUtil.getRandomGroundPosition(pos, (int)this.ritual.radius_x, (int)this.ritual.radius_z);
            Chunk chunk = this.field_70170_p.func_175726_f(random);
            int height = chunk.func_177433_f(random);
            if (height > maxY) continue;
            return new BlockPos(random.func_177958_n(), height + 1, random.func_177952_p());
        }
        return null;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        float alpha = (float)Math.min(40, RitualRegistry.ritual_heavy_storms.getDuration() + 20 - (Integer)this.func_184212_Q().func_187225_a(lifetime)) / 40.0f;
        if (this.field_70170_p.field_72995_K && (Integer)this.func_184212_Q().func_187225_a(lifetime) > 0) {
            float tz;
            float ty;
            float tx;
            float i;
            ParticleUtil.spawnParticleStar(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.0f, 0.0f, 0.0f, 50.0f, 50.0f, 255.0f, 0.5f * alpha, 20.0f, 40);
            if (this.field_70146_Z.nextInt(5) == 0) {
                ParticleUtil.spawnParticleSpark(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0625f * this.field_70146_Z.nextFloat(), 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), 50.0f, 50.0f, 255.0f, 1.0f * alpha, 1.0f + this.field_70146_Z.nextFloat(), 160);
            }
            for (i = 0.0f; i < 360.0f; i += this.field_70146_Z.nextFloat() * 90.0f) {
                tx = (float)this.field_70165_t + 2.5f * (float)Math.sin(Math.toRadians(i));
                ty = (float)this.field_70163_u;
                tz = (float)this.field_70161_v + 2.5f * (float)Math.cos(Math.toRadians(i));
                ParticleUtil.spawnParticleSmoke(this.field_70170_p, tx, ty, tz, 0.0f, 0.0f, 0.0f, 70.0f, 70.0f, 70.0f, 0.25f * alpha, 14.0f, 80, false);
            }
            for (i = 0.0f; i < 360.0f; i += this.field_70146_Z.nextFloat() * 90.0f) {
                tx = (float)this.field_70165_t + 3.75f * (float)Math.sin(Math.toRadians(i));
                ty = (float)this.field_70163_u;
                tz = (float)this.field_70161_v + 3.75f * (float)Math.cos(Math.toRadians(i));
                ParticleUtil.spawnParticleSmoke(this.field_70170_p, tx, ty, tz, 0.0f, 0.0f, 0.0f, 70.0f, 70.0f, 70.0f, 0.125f * alpha, 7.0f, 80, false);
            }
            for (i = 0.0f; i < 360.0f; i += this.field_70146_Z.nextFloat() * 90.0f) {
                float vx = 0.25f * (float)Math.sin(Math.toRadians(i));
                float vz = 0.25f * (float)Math.cos(Math.toRadians(i));
                float tx2 = (float)this.field_70165_t + 3.75f * (float)Math.sin(Math.toRadians(i));
                float ty2 = (float)this.field_70163_u;
                float tz2 = (float)this.field_70161_v + 3.75f * (float)Math.cos(Math.toRadians(i));
                ParticleUtil.spawnParticleSmoke(this.field_70170_p, tx2, ty2, tz2, vx, 0.0f, vz, 70.0f, 70.0f, 70.0f, 0.125f * alpha, 7.0f, 80, false);
            }
        }
        if (this.field_70173_aa % 20 == 0) {
            if (!this.field_70170_p.field_72995_K && !this.field_70170_p.func_72912_H().func_76059_o()) {
                this.field_70170_p.func_72912_H().func_76084_b(true);
            }
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - this.ritual.radius_x, this.field_70163_u - this.ritual.radius_y, this.field_70161_v - this.ritual.radius_z, this.field_70165_t + this.ritual.radius_x, this.field_70163_u + this.ritual.radius_y, this.field_70161_v + this.ritual.radius_z));
            for (EntityLivingBase e : entities) {
                if (!e.func_70027_ad()) continue;
                e.func_70066_B();
                if (!this.field_70170_p.field_72995_K) continue;
                for (float i = 0.0f; i < 24.0f; i += 1.0f) {
                    ParticleUtil.spawnParticleGlow(this.field_70170_p, (float)e.field_70165_t + 0.5f * (this.field_70146_Z.nextFloat() - 0.5f), (float)e.field_70163_u + e.field_70131_O / 2.5f + (this.field_70146_Z.nextFloat() - 0.5f), (float)e.field_70161_v + 0.5f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0625f * (this.field_70146_Z.nextFloat() - 0.5f), 0.009375f * this.field_70146_Z.nextFloat(), 0.0625f * (this.field_70146_Z.nextFloat() - 0.5f), 50.0f, 50.0f, 255.0f, 0.25f * alpha, 2.0f + 4.0f * this.field_70146_Z.nextFloat(), 80);
                }
            }
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextFloat() <= this.ritual.lightning_chance && this.strike_count <= this.ritual.max_strikes) {
                BlockPos pos = this.validPosition();
                if (!entities.isEmpty() && this.field_70146_Z.nextInt(5) == 0) {
                    pos = ((EntityLivingBase)entities.get(this.field_70146_Z.nextInt(entities.size()))).func_180425_c();
                }
                if (pos != null) {
                    this.field_70170_p.field_73007_j.add(new EntityLightningBolt(this.field_70170_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, false));
                    ++this.strike_count;
                }
            }
        }
    }
}

