/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.ritual;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.config.RitualConfig;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.init.ModDamage;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.network.fx.MessageRampantLifeInfusionFX;
import epicsquid.roots.recipe.AnimalHarvestFishRecipe;
import epicsquid.roots.ritual.RitualAnimalHarvest;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.util.types.WeightedRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityRitualAnimalHarvest
extends EntityRitualBase {
    private RitualAnimalHarvest ritual;
    private Set<Class<? extends EntityLivingBase>> harvestClasses;
    private static Method getLootTable = null;

    public EntityRitualAnimalHarvest(World worldIn) {
        super(worldIn);
        this.func_184212_Q().func_187214_a(lifetime, (Object)(RitualRegistry.ritual_animal_harvest.getDuration() + 20));
        this.harvestClasses = ModRecipes.getAnimalHarvestClasses();
        this.ritual = (RitualAnimalHarvest)RitualRegistry.ritual_animal_harvest;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % this.ritual.interval == 0) {
            for (int i = 0; i < this.ritual.count && !this.doHarvest(); ++i) {
            }
        }
    }

    private boolean doHarvest() {
        List entityList = Util.getEntitiesWithinRadius((World)this.field_70170_p, entity -> this.harvestClasses.contains(entity.getClass()), (BlockPos)this.func_180425_c(), (float)this.ritual.radius_x, (float)this.ritual.radius_y, (float)this.ritual.radius_z);
        if (RitualConfig.animalHarvestDoFish) {
            List waterSourceBlocks = Util.getBlocksWithinRadius((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)this.ritual.radius_x, (float)this.ritual.radius_y, (float)this.ritual.radius_z, p -> {
                IBlockState state = this.field_70170_p.func_180495_p(p);
                return state.func_185904_a() == Material.field_151586_h && state.func_177227_a().contains(BlockLiquid.field_176367_b) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
            });
            WeightedRegistry<AnimalHarvestFishRecipe> recipes = new WeightedRegistry<AnimalHarvestFishRecipe>((Collection<AnimalHarvestFishRecipe>)ModRecipes.getFishRecipes());
            if (!recipes.isEmpty() && !waterSourceBlocks.isEmpty() && this.field_70146_Z.nextFloat() <= this.ritual.fish_chance || entityList.isEmpty()) {
                AnimalHarvestFishRecipe recipe = recipes.getRandomItem(this.field_70146_Z);
                if (!waterSourceBlocks.isEmpty()) {
                    BlockPos pos = (BlockPos)waterSourceBlocks.get(this.field_70146_Z.nextInt(waterSourceBlocks.size()));
                    if (!this.field_70170_p.field_72995_K && recipe != null) {
                        ItemStack stack = recipe.getItemStack().func_77946_l();
                        stack.func_190920_e(this.ritual.fish_count + Math.max(0, this.field_70146_Z.nextInt(this.ritual.fish_additional) - 2));
                        ItemUtil.spawnItem((World)this.field_70170_p, (BlockPos)pos.func_177982_a(0, 1, 0), (ItemStack)stack);
                    }
                    PacketHandler.sendToAllTracking((IMessage)new MessageRampantLifeInfusionFX(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()), (Entity)this);
                }
                return true;
            }
        }
        if (entityList.isEmpty()) {
            return false;
        }
        EntityLiving entity2 = (EntityLiving)entityList.get(Util.rand.nextInt(entityList.size()));
        boolean didDrops = false;
        if (!this.field_70170_p.field_72995_K) {
            entity2.captureDrops = true;
            entity2.capturedDrops.clear();
            int looting = Util.rand.nextFloat() <= this.ritual.looting_chance ? this.ritual.looting_value : 0;
            this.dropLoot(entity2, looting);
            entity2.captureDrops = false;
            if (!ForgeHooks.onLivingDrops((EntityLivingBase)entity2, (DamageSource)DamageSource.field_76377_j, (ArrayList)entity2.capturedDrops, (int)looting, (boolean)false)) {
                for (EntityItem item : entity2.capturedDrops) {
                    item.field_70181_x = 0.0;
                    item.field_70159_w = 0.0;
                    item.field_70179_y = 0.0;
                    this.field_70170_p.func_72838_d((Entity)item);
                    didDrops = true;
                }
            }
        }
        if (didDrops) {
            entity2.func_70690_d(new PotionEffect(MobEffects.field_188423_x, this.ritual.glowing, 0, false, false));
        }
        return didDrops;
    }

    private ResourceLocation getLootTable(EntityLiving entity) {
        if (getLootTable == null) {
            getLootTable = ObfuscationReflectionHelper.findMethod(EntityLiving.class, (String)"func_184647_J", ResourceLocation.class, (Class[])new Class[0]);
            getLootTable.setAccessible(true);
        }
        try {
            return (ResourceLocation)getLootTable.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private void dropLoot(EntityLiving entity, int looting) {
        ResourceLocation resourcelocation = entity.field_184659_bA;
        if (resourcelocation == null) {
            resourcelocation = this.getLootTable(entity);
        }
        if (resourcelocation != null) {
            LootTable loottable = entity.field_70170_p.func_184146_ak().func_186521_a(resourcelocation);
            entity.field_184659_bA = null;
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)entity.field_70170_p));
            LootContext context = new LootContext((float)looting, (WorldServer)entity.field_70170_p, entity.field_70170_p.func_184146_ak(), (Entity)entity, (EntityPlayer)fakePlayer, ModDamage.HARVEST_RITUAL_DAMAGE);
            for (ItemStack itemstack : loottable.func_186462_a(entity.field_184653_bB == 0L ? entity.field_70146_Z : new Random(entity.field_184653_bB), context)) {
                entity.func_70099_a(itemstack, 0.0f);
            }
        }
    }
}

