/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.client.gui;

import epicsquid.mysticallib.client.gui.InvisibleButton;
import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.client.Keybinds;
import epicsquid.roots.container.ContainerLibrary;
import epicsquid.roots.container.slots.SlotLibraryInfo;
import epicsquid.roots.container.slots.SlotLibraryModifierInfo;
import epicsquid.roots.container.slots.SlotSpellInfo;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstance;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.MessageResetLibraryScreen;
import epicsquid.roots.network.MessageServerDeleteSpell;
import epicsquid.roots.spell.info.StaffSpellInfo;
import epicsquid.roots.spell.info.storage.StaffSpellStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiLibrary
extends GuiContainer {
    private ContainerLibrary container;
    private InvisibleButton backButton;
    private InvisibleButton resetButton;
    private static ResourceLocation SPELL_SELECT = new ResourceLocation("roots", "textures/gui/staff_gui.png");
    private static ResourceLocation SPELL_MODIFY = new ResourceLocation("roots", "textures/gui/staff_gui_modifiers.png");

    public GuiLibrary(@Nonnull ContainerLibrary container) {
        super((Container)container);
        this.container = container;
        this.field_146999_f = 256;
        this.field_147000_g = 152;
    }

    private boolean isSelectSpell() {
        return this.container.isSelectSpell();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!this.isSelectSpell()) {
            StaffSpellInfo info;
            FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            StaffSpellStorage storage = this.container.getSpellStorage();
            if (storage != null && (info = storage.getSpellInSlot(this.container.getSpellSlot())) != null) {
                String name = info.getNonNullSpell().getTextColor() + "" + TextFormatting.BOLD + I18n.func_135052_a((String)("roots.spell." + info.getNonNullSpell().getName() + ".name"), (Object[])new Object[0]);
                RenderHelper.func_74520_c();
                this.func_73732_a(renderer, name, this.field_146294_l / 2, this.field_147009_r, -1);
            }
        } else {
            FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            ItemStack staff = this.container.getStaff();
            if (!staff.func_190926_b() && staff.func_82837_s()) {
                RenderHelper.func_74520_c();
                this.func_73732_a(renderer, staff.func_82833_r(), this.field_146294_l / 2, this.field_147009_r - this.field_147009_r / 3, -1);
            }
        }
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.backButton = new InvisibleButton(0, this.field_147003_i + 183, this.field_147009_r + 136, 32, 22, I18n.func_135052_a((String)"roots.imposer.back", (Object[])new Object[0]));
        this.resetButton = new InvisibleButton(0, this.field_147003_i + 183, this.field_147009_r + 136, 32, 22, I18n.func_135052_a((String)"roots.library.reset", (Object[])new Object[0]));
        this.field_146292_n.add(this.backButton);
        this.field_146292_n.add(this.resetButton);
    }

    protected void func_191948_b(int x, int y) {
        if (this.field_146297_k == null || this.field_146297_k.field_71439_g == null) {
            return;
        }
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null) {
            StaffModifierInstance instance;
            SlotSpellInfo spellInfo;
            ArrayList<String> tooltip = new ArrayList<String>();
            FontRenderer font = null;
            boolean hasStack = this.field_147006_u.func_75216_d();
            ItemStack stack = this.field_147006_u.func_75211_c();
            SlotLibraryModifierInfo info = null;
            if (this.field_147006_u instanceof SlotLibraryModifierInfo) {
                info = (SlotLibraryModifierInfo)this.field_147006_u;
                if (stack.func_190926_b()) {
                    stack = info.getCore().getStack();
                    hasStack = true;
                }
                StaffModifierInstanceList modifiers = this.container.getModifiers();
                if (info.isDisabled() && info.isApplicable() && info.isApplied() && !info.isConflicting(modifiers)) {
                    tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.modifier.not_enabled", (Object[])new Object[0]));
                } else if (!info.isApplied() && info.isApplicable() && !info.isConflicting(modifiers)) {
                    tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.modifier.not_applied", (Object[])new Object[0]));
                } else if (!info.isApplicable() && !info.isConflicting(modifiers)) {
                    tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.modifier.not_applicable", (Object[])new Object[0]));
                    stack = ItemStack.field_190927_a;
                    hasStack = false;
                } else if (info.isConflicting(modifiers)) {
                    List<StaffModifierInstance> conflicts = info.getConflicts(modifiers);
                    StringJoiner joiner = new StringJoiner(", ");
                    conflicts.forEach(o -> joiner.add(I18n.func_135052_a((String)o.getTranslationKey(), (Object[])new Object[0])));
                    tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.modifier.conflicting1", (Object[])new Object[]{joiner.toString()}));
                    tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.modifier.conflicting2", (Object[])new Object[0]));
                }
            } else if (this.field_147006_u instanceof SlotSpellInfo && (spellInfo = (SlotSpellInfo)this.field_147006_u).func_75216_d()) {
                tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.modifier.activate", (Object[])new Object[0]));
                tooltip.add(TextFormatting.BOLD + I18n.func_135052_a((String)"roots.tooltip.spell.delete", (Object[])new Object[]{Keybinds.DELETE_SPELL.getDisplayName()}));
            }
            if (hasStack) {
                GuiUtils.preItemToolTip((ItemStack)stack);
                tooltip.addAll(this.func_191927_a(stack));
                font = stack.func_77973_b().getFontRenderer(stack);
            }
            if (info != null && (instance = info.get()) != null && !instance.isDisabled()) {
                tooltip.add("");
                tooltip.add(instance.describeName());
                tooltip.add(instance.describeFunction());
                tooltip.add("");
                tooltip.addAll(instance.describeCost());
            }
            if (!tooltip.isEmpty()) {
                this.drawHoveringText(tooltip, x, y, font == null ? this.field_146289_q : font);
                if (hasStack) {
                    GuiUtils.postItemToolTip();
                }
            }
        }
    }

    protected ResourceLocation getTexture() {
        return this.container.isSelectSpell() ? SPELL_SELECT : SPELL_MODIFY;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation tex = this.getTexture();
        this.backButton.field_146125_m = tex != SPELL_SELECT;
        this.resetButton.field_146125_m = tex == SPELL_SELECT;
        this.field_146297_k.func_110434_K().func_110577_a(tex);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, 256, 152);
    }

    public void func_146977_a(Slot slot) {
        SlotLibraryModifierInfo modInfo;
        int i2 = slot.field_75223_e - 2;
        int j2 = slot.field_75221_f - 2;
        if (slot instanceof SlotLibraryModifierInfo && (!(modInfo = (SlotLibraryModifierInfo)slot).isApplicable() || !modInfo.isApplied() || modInfo.isDisabled() || modInfo.isConflicting(this.container.getModifiers()))) {
            int v = -1;
            if (!modInfo.isApplicable()) {
                v = 40;
            } else if (!modInfo.isApplied()) {
                v = 20;
            } else if (modInfo.isConflicting(this.container.getModifiers())) {
                v = 60;
            } else if (modInfo.isDisabled()) {
                v = 0;
            }
            if (v != -1) {
                this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
                GlStateManager.func_179140_f();
                GlStateManager.func_179141_d();
                this.func_73729_b(i2, j2, 0, 152 + v, 20, 20);
                GlStateManager.func_179118_c();
                GlStateManager.func_179145_e();
            }
        }
        super.func_146977_a(slot);
        if (slot instanceof SlotSpellInfo) {
            if (((SlotSpellInfo)slot).getSlot() == this.container.getStaffSlot()) {
                this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
                this.func_73729_b(i2, j2, 0, 170, 20, 20);
            }
        } else if (slot instanceof SlotLibraryInfo && ((SlotLibraryInfo)slot).getSlot() == this.container.getLibrarySlot() - 5) {
            this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
            this.func_73729_b(i2 + 1, j2 + 1, 0, 152, 18, 18);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.backButton.field_146127_k || button.field_146127_k == this.resetButton.field_146127_k) {
            MessageResetLibraryScreen packet = new MessageResetLibraryScreen();
            PacketHandler.INSTANCE.sendToServer((IMessage)packet);
            this.container.setSelectSpell();
            this.container.reset();
        }
        super.func_146284_a(button);
    }

    protected void func_73869_a(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        if (Keybinds.DELETE_SPELL.isActiveAndMatches(p_keyTyped_2_)) {
            Slot slot = this.getSlotUnderMouse();
            if (slot instanceof SlotSpellInfo) {
                MessageServerDeleteSpell packet = new MessageServerDeleteSpell(((SlotSpellInfo)slot).getSlot());
                PacketHandler.INSTANCE.sendToServer((IMessage)packet);
            }
        } else {
            super.func_73869_a(p_keyTyped_1_, p_keyTyped_2_);
        }
    }
}

