/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.block;

import epicsquid.mysticallib.block.BlockTEBase;
import epicsquid.mysticallib.proxy.ClientProxy;
import epicsquid.roots.particle.ParticlePyreLeaf;
import epicsquid.roots.recipe.PyreCraftingRecipe;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.tileentity.TileEntityPyre;
import epicsquid.roots.util.RitualUtil;
import epicsquid.roots.util.types.BlockPosDimension;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPyre
extends BlockTEBase {
    public static PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");
    public static Map<BlockPosDimension, RitualBase> ritualCache = new HashMap<BlockPosDimension, RitualBase>();
    public static Map<BlockPosDimension, PyreCraftingRecipe> recipeCache = new HashMap<BlockPosDimension, PyreCraftingRecipe>();

    public BlockPyre(@Nonnull Material mat, @Nonnull SoundType type, float hardness, @Nonnull String name, @Nonnull Class<? extends TileEntity> teClass) {
        super(mat, type, hardness, name, teClass);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)));
    }

    public void attemptRegistry(@Nonnull Class<? extends TileEntity> c, String name) {
        if (!BlockTEBase.classes.contains(c)) {
            BlockTEBase.classes.add(c);
            GameRegistry.registerTileEntity(c, (ResourceLocation)new ResourceLocation("roots", "tile_entity_bonfire"));
        }
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.BOWL;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return new AxisAlignedBB(-0.125, 0.0, -0.125, 1.125, 0.25, 1.125);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BURNING});
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false));
    }

    public static void setState(boolean burning, World world, BlockPos pos) {
        if (burning) {
            world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BURNING) != false ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)BURNING)).booleanValue()) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
            List<BlockPos> standingStones = RitualUtil.getNearbyPositions(RitualUtil.Runestone.get(), world, pos, -1);
            for (RitualUtil.RunedWoodType type : RitualUtil.RunedWoodType.values()) {
                standingStones.addAll(RitualUtil.getNearbyPositions(type, world, pos, -1));
            }
            if (!standingStones.isEmpty()) {
                Vec3d me = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5);
                for (BlockPos runestone : standingStones) {
                    if (rand.nextInt(6) != 0) continue;
                    Vec3d origAngle = me.func_178788_d(new Vec3d((Vec3i)runestone).func_72441_c(0.5 + rand.nextDouble() - 0.5, 0.5 + rand.nextDouble() - 0.5, 0.5 + rand.nextDouble() - 0.5));
                    Vec3d angle = origAngle.func_72432_b().func_186678_a(0.05);
                    ClientProxy.particleRenderer.spawnParticle(world, ParticlePyreLeaf.class, (double)runestone.func_177958_n() + 0.5, (double)runestone.func_177956_o() + 0.5, (double)runestone.func_177952_p() + 0.5, angle.field_72450_a * 0.5, angle.field_72448_b * 0.5, angle.field_72449_c * 0.5, new double[]{origAngle.func_189985_c() * 10.0 - 5.0, 0.23529411764705882 + rand.nextDouble() * 0.05, 0.47058823529411764 + rand.nextDouble() * 0.05, 0.23529411764705882 + rand.nextDouble() * 0.05, 1.0, 2.5, 0.0, me.field_72450_a, me.field_72448_b, me.field_72449_c, 0.65});
                }
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityPyre) {
            TileEntityPyre bon = (TileEntityPyre)te;
            boolean lit = bon.getBurnTime() != 0;
            BlockPosDimension pdos = new BlockPosDimension(pos, worldIn.field_73011_w.getDimension());
            RitualBase ritual = ritualCache.get(pdos);
            if (!(ritual != null && ritual.isRitualRecipe(bon, null) || (ritual = RitualRegistry.getRitual(bon, null)) == null || ritual.isDisabled())) {
                ritualCache.put(pdos, ritual);
            }
            if (ritual != null) {
                if (ritual.equals(bon.getLastRitualUsed()) && lit) {
                    return 5;
                }
                return lit ? 4 : 1;
            }
            PyreCraftingRecipe recipe = recipeCache.get(pdos);
            if (recipe == null && (recipe = bon.getCurrentRecipe()) != null) {
                recipeCache.put(pdos, recipe);
            }
            if (recipe != null) {
                if (recipe.equals(bon.getLastRecipeUsed()) && lit) {
                    return 5;
                }
                return lit ? 4 : 1;
            }
            return lit ? 3 : 0;
        }
        return 0;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }
}

