/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules.passive;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule
public class StickModule
implements IModule {
    private final IForm stickForm = ApiImpl.INSTANCE.newForm(this, "stick", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.NON_DUSTS);
    private static boolean registerRodOredict = true;

    @Override
    public String getName() {
        return "stick";
    }

    @Override
    public boolean isPassive() {
        return true;
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.stickForm.toRequest());
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        registerRodOredict = config.getDefinedBoolean("oredict.registerRodOredict", registerRodOredict, "Should the module register rod oredict for sticks.");
    }

    @Override
    public void onMaterialComputeComplete(IModuleData moduleData) {
        ApiImpl api = ApiImpl.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        for (IMaterial material : this.stickForm.getMaterials()) {
            if (!registerRodOredict) continue;
            IItemInfo stickInfo = itemFormType.getMaterialFormInfo(this.stickForm, material);
            ((JAOPCAApi)api).registerOredict(miscHelper.getOredictName("rod", material.getName()), stickInfo.asItem());
        }
    }

    @Override
    public Map<String, String> getLegacyRemaps() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"stick", (Object)"stick");
        return builder.build();
    }
}

