/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules.active;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule
public class DustModule
implements IModule {
    private final IForm dustForm = ApiImpl.INSTANCE.newForm(this, "dust", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.NON_DUSTS);

    @Override
    public String getName() {
        return "dust";
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.dustForm.toRequest());
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : this.dustForm.getMaterials()) {
            if (!material.getType().isIngot()) continue;
            String dustOredict = miscHelper.getOredictName("dust", material.getName());
            String materialOredict = miscHelper.getOredictName(material.getType().getFormName(), material.getName());
            ((JAOPCAApi)api).registerSmeltingRecipe(miscHelper.getRecipeKey("dust.to_material", material.getName()), dustOredict, materialOredict, 1, 0.7f);
        }
    }

    @Override
    public Map<String, String> getLegacyRemaps() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"dust", (Object)"dust");
        return builder.build();
    }
}

