/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules.active;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.blocks.IBlockInfo;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule
public class BlockModule
implements IModule {
    private final IForm storageBlockForm = ApiImpl.INSTANCE.newForm(this, "block", BlockFormType.INSTANCE);

    @Override
    public String getName() {
        return "block";
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.storageBlockForm.toRequest());
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : this.storageBlockForm.getMaterials()) {
            IBlockInfo storageBlockInfo = BlockFormType.INSTANCE.getMaterialFormInfo(this.storageBlockForm, material);
            String storageBlockOredict = miscHelper.getOredictName("block", material.getName());
            String materialOredict = miscHelper.getOredictName(material.getType().getFormName(), material.getName());
            if (material.isSmallStorageBlock()) {
                ((JAOPCAApi)api).registerShapedRecipe(miscHelper.getRecipeKey("block.to_block", material.getName()), storageBlockInfo, 1, "MM", "MM", Character.valueOf('M'), materialOredict);
            } else {
                ((JAOPCAApi)api).registerShapedRecipe(miscHelper.getRecipeKey("block.to_block", material.getName()), storageBlockInfo, 1, "MMM", "MMM", "MMM", Character.valueOf('M'), materialOredict);
            }
            ((JAOPCAApi)api).registerShapelessRecipe(miscHelper.getRecipeKey("block.to_material", material.getName()), (Object)materialOredict, material.isSmallStorageBlock() ? 4 : 9, storageBlockOredict);
        }
    }

    @Override
    public Map<String, String> getLegacyRemaps() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"block", (Object)"block");
        return builder.build();
    }
}

