/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.google.common.base.Predicates;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleData;
import thelm.jaopca.utils.MiscHelper;

public class ModuleHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String JAOPCA_MODULE = JAOPCAModule.class.getCanonicalName();
    private static final TreeMap<String, IModule> MODULES = new TreeMap();
    private static final TreeMap<IModule, ModuleData> MODULE_DATAS = new TreeMap();

    private ModuleHandler() {
    }

    public static Map<String, IModule> getModuleMap() {
        return MODULES;
    }

    public static Collection<IModule> getModules() {
        return MODULES.values();
    }

    public static Map<IModule, ModuleData> getModuleDataMap() {
        return MODULE_DATAS;
    }

    public static ModuleData getModuleData(String name) {
        IModule module = MODULES.get(name);
        return module != null ? MODULE_DATAS.get(module) : null;
    }

    public static ModuleData getModuleData(IModule module) {
        return MODULE_DATAS.get(module);
    }

    public static Collection<ModuleData> getModuleDatas() {
        return MODULE_DATAS.values();
    }

    public static void findModules(ASMDataTable asmDataTable) {
        MODULES.clear();
        Set annotationData = asmDataTable.getAll(JAOPCA_MODULE);
        for (ASMDataTable.ASMData aData : annotationData) {
            List deps = (List)aData.getAnnotationInfo().get("modDependencies");
            Predicate<String> modVersionNotLoaded = MiscHelper.INSTANCE.modVersionNotLoaded(LOGGER);
            String className = aData.getClassName();
            if (deps != null && deps.stream().filter(Predicates.notNull()).anyMatch(modVersionNotLoaded)) {
                LOGGER.info("Module {} has missing mod dependencies, skipping", (Object)className);
                continue;
            }
            try {
                IModule module;
                Class<?> moduleClass = Class.forName(className);
                Class<IModule> moduleInstanceClass = moduleClass.asSubclass(IModule.class);
                try {
                    Method method = moduleClass.getMethod("getInstance", new Class[0]);
                    module = (IModule)method.invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    module = moduleInstanceClass.newInstance();
                }
                if (MODULES.putIfAbsent(module.getName(), module) != null) {
                    LOGGER.fatal("Module name conflict: {} for {} and {}", (Object)module.getName(), MODULES.get(module.getName()).getClass(), module.getClass());
                    continue;
                }
                ModuleData mData = new ModuleData(module);
                MODULE_DATAS.put(module, mData);
                LOGGER.debug("Loaded module {}", (Object)module.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.fatal("Unable to load module {}", (Object)className, (Object)e);
            }
        }
    }

    public static void computeValidMaterials() {
        List<IMaterial> materials;
        for (ModuleData data : ModuleHandler.getModuleDatas()) {
            materials = MaterialHandler.getMaterials().stream().filter(data.getModule().isPassive() ? material -> data.getConfigPassiveMaterialWhitelist().contains(material.getName()) : data::isMaterialModuleValid).collect(Collectors.toList());
            for (IMaterial material2 : materials) {
                if (data.isMaterialDependencyValid(material2, new HashSet<Pair<ModuleData, IMaterial>>())) {
                    data.addDependencyRequestedMaterial(material2);
                    continue;
                }
                data.addRejectedMaterial(material2);
            }
        }
        for (ModuleData data : ModuleHandler.getModuleDatas()) {
            materials = MaterialHandler.getMaterials().stream().filter(data::isMaterialValid).collect(Collectors.toList());
            data.setMaterials(materials);
        }
    }

    public static void onMaterialComputeComplete() {
        for (IModule module : ModuleHandler.getModules()) {
            module.onMaterialComputeComplete(ModuleHandler.getModuleData(module));
        }
    }

    public static void onInit(FMLInitializationEvent event) {
        for (IModule module : ModuleHandler.getModules()) {
            module.onInit(ModuleHandler.getModuleData(module), event);
        }
    }

    public static void onPostInit(FMLPostInitializationEvent event) {
        for (IModule module : ModuleHandler.getModules()) {
            module.onPostInit(ModuleHandler.getModuleData(module), event);
        }
    }
}

