/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.localization;

import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import thelm.jaopca.api.localization.ILocalizer;
import thelm.jaopca.localization.LocalizerDefault;
import thelm.jaopca.utils.MiscHelper;

public class LocalizationHandler {
    private static final TreeMap<String, ILocalizer> LOCALIZERS = new TreeMap();

    public static void registerLocalizer(ILocalizer localizer, String ... languages) {
        Objects.requireNonNull(localizer);
        for (String language : Objects.requireNonNull(languages)) {
            LOCALIZERS.put(language, localizer);
        }
    }

    public static ILocalizer getCurrentLocalizer() {
        return LOCALIZERS.computeIfAbsent(LocalizationHandler.getLanguage(), key -> LocalizerDefault.INSTANCE);
    }

    public static String getLanguage() {
        return (String)MiscHelper.INSTANCE.conditionalSupplier(() -> ((Side)FMLCommonHandler.instance().getSide()).isClient(), () -> () -> {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc != null) {
                Language lang = mc.func_135016_M().func_135041_c();
                if (lang != null) {
                    return lang.func_135034_a();
                }
                return mc.field_71474_y.field_74363_ab;
            }
            return "en_us";
        }, () -> () -> "en_us").get();
    }
}

