/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.items;

import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.items.IItemFormSettings;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCAItem
extends Item
implements IMaterialFormItem {
    private final IForm form;
    private final IMaterial material;
    protected final IItemFormSettings settings;
    protected OptionalInt itemStackLimit = OptionalInt.empty();
    protected Optional<Boolean> hasEffect = Optional.empty();
    protected Optional<EnumRarity> rarity = Optional.empty();
    protected OptionalInt burnTime = OptionalInt.empty();
    protected Optional<String> translationKey = Optional.empty();

    public JAOPCAItem(IForm form, IMaterial material, IItemFormSettings settings) {
        this.form = form;
        this.material = material;
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public int getItemStackLimit(ItemStack stack) {
        if (!this.itemStackLimit.isPresent()) {
            this.itemStackLimit = OptionalInt.of(this.settings.getItemStackLimitFunction().applyAsInt(this.material));
        }
        return this.itemStackLimit.getAsInt();
    }

    public boolean func_77636_d(ItemStack stack) {
        if (!this.hasEffect.isPresent()) {
            this.hasEffect = Optional.of(this.settings.getHasEffectFunction().test(this.material));
        }
        return this.hasEffect.get() != false || super.func_77636_d(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (!this.rarity.isPresent()) {
            this.rarity = Optional.of(this.settings.getDisplayRarityFunction().apply((Object)this.material));
        }
        return this.rarity.get();
    }

    public int getItemBurnTime(ItemStack itemStack) {
        if (!this.burnTime.isPresent()) {
            this.burnTime = OptionalInt.of(this.settings.getBurnTimeFunction().applyAsInt(this.material));
        }
        return this.burnTime.getAsInt();
    }

    public String func_77658_a() {
        if (!this.translationKey.isPresent()) {
            ResourceLocation id = this.getRegistryName();
            this.translationKey = Optional.of("item." + id.func_110624_b() + "." + id.func_110623_a().replace('/', '.'));
        }
        return this.translationKey.get();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("item.jaopca." + this.getForm().getName(), this.getMaterial(), this.func_77667_c(stack));
    }
}

