/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.items;

import com.google.common.collect.TreeBasedTable;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.items.IItemFormSettings;
import thelm.jaopca.api.items.IItemFormType;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.custom.json.EnumDeserializer;
import thelm.jaopca.custom.json.ItemFormSettingsDeserializer;
import thelm.jaopca.forms.FormTypeHandler;
import thelm.jaopca.items.ItemFormSettings;
import thelm.jaopca.items.ItemInfo;
import thelm.jaopca.oredict.OredictHandler;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class ItemFormType
implements IItemFormType {
    public static final ItemFormType INSTANCE = new ItemFormType();
    private static final TreeSet<IForm> FORMS = new TreeSet();
    private static final TreeBasedTable<IForm, IMaterial, IMaterialFormItem> ITEMS = TreeBasedTable.create();
    private static final TreeBasedTable<IForm, IMaterial, IItemInfo> ITEM_INFOS = TreeBasedTable.create();
    private static boolean registered = false;
    private static CreativeTabs creativeTab;

    private ItemFormType() {
    }

    public static void init() {
        FormTypeHandler.registerFormType(INSTANCE);
    }

    @Override
    public String getName() {
        return "item";
    }

    @Override
    public void addForm(IForm form) {
        FORMS.add(form);
    }

    @Override
    public Set<IForm> getForms() {
        return Collections.unmodifiableNavigableSet(FORMS);
    }

    @Override
    public boolean shouldRegister(IForm form, IMaterial material) {
        String oredictName = MiscHelper.INSTANCE.getOredictName(form.getSecondaryName(), material.getName());
        return !OredictHandler.getOredict().contains(oredictName);
    }

    @Override
    public IItemInfo getMaterialFormInfo(IForm form, IMaterial material) {
        IItemInfo info = (IItemInfo)ITEM_INFOS.get((Object)form, (Object)material);
        if (info == null && FORMS.contains(form) && form.getMaterials().contains(material)) {
            info = new ItemInfo((IMaterialFormItem)ITEMS.get((Object)form, (Object)material));
            ITEM_INFOS.put((Object)form, (Object)material, (Object)info);
        }
        return info;
    }

    @Override
    public IItemFormSettings getNewSettings() {
        return new ItemFormSettings();
    }

    @Override
    public GsonBuilder configureGsonBuilder(GsonBuilder builder) {
        return builder.registerTypeAdapter(EnumRarity.class, (Object)EnumDeserializer.INSTANCE);
    }

    @Override
    public IItemFormSettings deserializeSettings(JsonElement jsonElement, JsonDeserializationContext context) {
        return ItemFormSettingsDeserializer.INSTANCE.deserialize(jsonElement, context);
    }

    @Override
    public void registerMaterialForms() {
        if (registered) {
            return;
        }
        registered = true;
        ApiImpl api = ApiImpl.INSTANCE;
        MiscHelper helper = MiscHelper.INSTANCE;
        for (IForm form : FORMS) {
            IItemFormSettings settings = (IItemFormSettings)form.getSettings();
            String secondaryName = form.getSecondaryName();
            for (IMaterial material : form.getMaterials()) {
                ResourceLocation registryName = new ResourceLocation("jaopca", form.getName() + '.' + helper.toLowercaseUnderscore(material.getName()));
                IMaterialFormItem materialFormItem = settings.getItemCreator().create(form, material, settings);
                Item item = materialFormItem.asItem();
                item.setRegistryName(registryName);
                item.func_77637_a(creativeTab);
                ITEMS.put((Object)form, (Object)material, (Object)materialFormItem);
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
                api.registerOredict(helper.getOredictName(secondaryName, material.getName()), item);
                for (String alternativeName : material.getAlternativeNames()) {
                    api.registerOredict(helper.getOredictName(secondaryName, alternativeName), item);
                }
            }
        }
    }

    public static CreativeTabs getCreativeTab() {
        if (creativeTab == null) {
            creativeTab = new CreativeTabs("jaopca"){

                public ItemStack func_78016_d() {
                    return new ItemStack(Items.field_151114_aO);
                }
            };
        }
        return creativeTab;
    }

    public static Collection<IMaterialFormItem> getItems() {
        return ITEMS.values();
    }
}

