/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;

public class JAOPCAFluidBlock
extends BlockFluidClassic
implements IMaterialFormFluidBlock {
    private final IMaterialFormFluid fluid;
    protected final IFluidFormSettings settings;
    protected Optional<Material> blockMaterial = Optional.empty();
    protected Optional<MapColor> mapColor = Optional.empty();
    protected OptionalDouble blockHardness = OptionalDouble.empty();
    protected OptionalDouble explosionResistance = OptionalDouble.empty();
    protected OptionalInt flammability = OptionalInt.empty();
    protected OptionalInt fireSpreadSpeed = OptionalInt.empty();
    protected Optional<Boolean> isFireSource = Optional.empty();

    public JAOPCAFluidBlock(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(fluid.asFluid(), Material.field_151586_h);
        this.fluid = fluid;
        this.settings = settings;
        this.setQuantaPerBlock(settings.getMaxLevelFunction().applyAsInt(this.getMaterial()));
    }

    @Override
    public IForm getForm() {
        return this.fluid.getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return this.fluid.getMaterial();
    }

    public Material func_149688_o(IBlockState state) {
        if (!this.blockMaterial.isPresent()) {
            this.blockMaterial = Optional.of(this.settings.getMaterialFunction().apply(this.getMaterial()));
        }
        return this.blockMaterial.get();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (!this.mapColor.isPresent()) {
            this.mapColor = Optional.of(this.settings.getMapColorFunction().apply(this.getMaterial()));
        }
        return this.mapColor.get();
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (!this.blockHardness.isPresent()) {
            this.blockHardness = OptionalDouble.of(this.settings.getBlockHardnessFunction().applyAsDouble(this.getMaterial()));
        }
        return (float)this.blockHardness.getAsDouble();
    }

    public float func_149638_a(Entity exploder) {
        if (!this.explosionResistance.isPresent()) {
            this.explosionResistance = OptionalDouble.of(this.settings.getExplosionResistanceFunction().applyAsDouble(this.getMaterial()));
        }
        return (float)this.explosionResistance.getAsDouble();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (!this.flammability.isPresent()) {
            this.flammability = OptionalInt.of(this.settings.getFireSpreadSpeedFunction().applyAsInt(this.getMaterial()));
        }
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (!this.fireSpreadSpeed.isPresent()) {
            this.fireSpreadSpeed = OptionalInt.of(this.settings.getFlammabilityFunction().applyAsInt(this.getMaterial()));
        }
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        if (!this.isFireSource.isPresent()) {
            this.isFireSource = Optional.of(this.settings.getIsFireSourceFunction().test(this.getMaterial()));
        }
        return this.isFireSource.get();
    }
}

