/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.Lists;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.config.DynamicSpecConfig;
import thelm.jaopca.custom.CustomModule;
import thelm.jaopca.materials.Material;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleData;
import thelm.jaopca.modules.ModuleHandler;
import thelm.jaopca.utils.MiscHelper;

public class ConfigHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Path configDir;
    private static Path customFormConfigFile;
    private static Path materialConfigDir;
    private static Path moduleConfigDir;
    private static IDynamicSpecConfig mainConfig;
    private static final TreeMap<IMaterial, IDynamicSpecConfig> MATERIAL_CONFIGS;
    private static final TreeMap<IModule, IDynamicSpecConfig> MODULE_CONFIGS;
    public static boolean ingot;
    public static boolean gem;
    public static boolean crystal;
    public static boolean dust;
    public static boolean ingotPlain;
    public static boolean gemPlain;
    public static boolean crystalPlain;
    public static boolean dustPlain;
    public static boolean nonPlainUsedPrefix;
    public static boolean strictUsedPrefix;
    public static final List<String> DEFAULT_GEM_OVERRIDES;
    public static final List<String> DEFAULT_CRYSTAL_OVERRIDES;
    public static final List<String> DEFAULT_DUST_OVERRIDES;
    public static final Set<String> GEM_OVERRIDES;
    public static final Set<String> CRYSTAL_OVERRIDES;
    public static final Set<String> DUST_OVERRIDES;
    private static final List<String> DEFAULT_PREFERRED_MODS;
    public static final List<String> PREFERRED_MODS;
    public static final Set<String> OREDICT_BLACKLIST;
    public static final Set<String> OREDICT_MODULE_BLACKLIST;
    public static final List<String> CUSTOM_OREDICT;
    public static final Set<ResourceLocation> RECIPE_BLACKLIST;
    public static final List<Pattern> RECIPE_REGEX_BLACKLIST;
    public static double gammaValue;
    public static boolean resetColors;
    public static boolean checkL10nUpdates;
    public static double updateInterval;

    private ConfigHandler() {
    }

    public static void setupMainConfig(Path modConfigDir) {
        configDir = modConfigDir.resolve("jaopca");
        if (!Files.exists(configDir, new LinkOption[0]) || !Files.isDirectory(configDir, new LinkOption[0])) {
            try {
                if (Files.exists(configDir, new LinkOption[0]) && !Files.isDirectory(configDir, new LinkOption[0])) {
                    LOGGER.warn("Config directory {} is a file, deleting", (Object)configDir);
                    Files.delete(configDir);
                }
                Files.createDirectory(configDir, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create config directory " + configDir, e);
            }
        }
        mainConfig = new DynamicSpecConfig((CommentedConfig)CommentedFileConfig.builder(configDir.resolve("main.toml")).sync().backingMapCreator(LinkedHashMap::new).autosave().build());
        mainConfig.setComment("materials", "Configurations related to materials.");
        ingot = mainConfig.getDefinedBoolean("materials.ingot", ingot, "Should the mod find ingot materials with ores.");
        gem = mainConfig.getDefinedBoolean("materials.gem", gem, "Should the mod find gem materials with ores.");
        crystal = mainConfig.getDefinedBoolean("materials.crystal", crystal, "Should the mod find crystal materials with ores.");
        dust = mainConfig.getDefinedBoolean("materials.dust", dust, "Should the mod find dust materials with ores.");
        ingotPlain = mainConfig.getDefinedBoolean("materials.ingotPlain", ingotPlain, "Should the mod find ingot materials without ores.");
        gemPlain = mainConfig.getDefinedBoolean("materials.gemPlain", gemPlain, "Should the mod find gem materials without ores.");
        crystalPlain = mainConfig.getDefinedBoolean("materials.crystalPlain", crystalPlain, "Should the mod find crystal materials without ores.");
        dustPlain = mainConfig.getDefinedBoolean("materials.dustPlain", dustPlain, "Should the mod find dust materials without ores.");
        nonPlainUsedPrefix = mainConfig.getDefinedBoolean("materials.nonPlainUsedPrefix", nonPlainUsedPrefix, "Should the mod not find materials with ores with used prefixes.");
        strictUsedPrefix = mainConfig.getDefinedBoolean("materials.strictUsedPrefix", strictUsedPrefix, "Should the mod not find materials with used prefixes when the material name is not found yet.");
        mainConfig.setComment("materialOverrides", "Configurations related to material overrides.");
        GEM_OVERRIDES.addAll(mainConfig.getDefinedStringList("materialOverrides.gem", DEFAULT_GEM_OVERRIDES, "List of materials that should be gems."));
        CRYSTAL_OVERRIDES.addAll(mainConfig.getDefinedStringList("materialOverrides.crystal", DEFAULT_CRYSTAL_OVERRIDES, "List of materials that should be crystals."));
        DUST_OVERRIDES.addAll(mainConfig.getDefinedStringList("materialOverrides.dust", DEFAULT_DUST_OVERRIDES, "List of materials that should be dusts."));
        mainConfig.setComment("itemSelection", "Configurations related to item selection.");
        PREFERRED_MODS.addAll(mainConfig.getDefinedStringList("itemSelection.preferredMods", DEFAULT_PREFERRED_MODS, "List of mods that are preferred when selecting items in recipes."));
        mainConfig.setComment("oredict", "Configurations related to the ore dictionary.");
        OREDICT_BLACKLIST.addAll(mainConfig.getDefinedStringList("oredict.blacklist", new ArrayList<String>(), "List of oredict names that should not be added."));
        OREDICT_MODULE_BLACKLIST.addAll(mainConfig.getDefinedStringList("oredict.moduleBlacklist", new ArrayList<String>(), "List of oredict modules that should not be registered."));
        CUSTOM_OREDICT.addAll(mainConfig.getDefinedStringList("oredict.custom", new ArrayList<String>(), "List of custom oredict entries to add. Format: <mod:item@meta=oredict>"));
        mainConfig.setComment("recipes", "Configurations related to recipes.");
        RECIPE_BLACKLIST.addAll(Lists.transform(mainConfig.getDefinedStringList("recipes.blacklist", new ArrayList<String>(), "List of recipes that should not be added."), ResourceLocation::new));
        RECIPE_REGEX_BLACKLIST.addAll(Lists.transform(mainConfig.getDefinedStringList("recipes.regexBlacklist", new ArrayList<String>(), "List of recipes by regex that should not be added."), Pattern::compile));
        mainConfig.setComment("colors", "Configurations related to color generation.");
        gammaValue = mainConfig.getDefinedDouble("colors.gammaValue", gammaValue, "The gamma value used to blend colors.");
        resetColors = mainConfig.getDefinedBoolean("colors.resetColors", false, "Should colors of all materials be reset on next startup.");
        mainConfig.set("colors.resetColors", (Object)false);
        mainConfig.setComment("materialLocalization", "Configurations related to material localization.");
        checkL10nUpdates = mainConfig.getDefinedBoolean("materialLocalization.checkL10nUpdates", checkL10nUpdates, "Should the mod check for material localization updates.");
        updateInterval = mainConfig.getDefinedDouble("materialLocalization.updateInterval", updateInterval, "The update interval of localization files in days.");
    }

    public static void setupCustomFormConfig() {
        customFormConfigFile = configDir.resolve("custom_forms.json");
        try {
            if (!Files.exists(customFormConfigFile, new LinkOption[0])) {
                Files.createFile(customFormConfigFile, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create config file " + customFormConfigFile, e);
        }
        CustomModule.instance.setCustomFormConfigFile(customFormConfigFile);
    }

    public static void setupMaterialConfigs() {
        materialConfigDir = configDir.resolve("materials");
        if (!Files.exists(materialConfigDir, new LinkOption[0]) || !Files.isDirectory(materialConfigDir, new LinkOption[0])) {
            try {
                if (Files.exists(materialConfigDir, new LinkOption[0]) && !Files.isDirectory(materialConfigDir, new LinkOption[0])) {
                    LOGGER.warn("Config directory {} is a file, deleting", (Object)materialConfigDir);
                    Files.delete(materialConfigDir);
                }
                Files.createDirectory(materialConfigDir, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create config directory " + materialConfigDir, e);
            }
        }
        MATERIAL_CONFIGS.clear();
        for (Material material : MaterialHandler.getMaterials()) {
            DynamicSpecConfig config = new DynamicSpecConfig((CommentedConfig)CommentedFileConfig.builder(materialConfigDir.resolve(MiscHelper.INSTANCE.toLowercaseUnderscore(material.getName()) + ".toml")).sync().backingMapCreator(LinkedHashMap::new).autosave().build());
            MATERIAL_CONFIGS.put(material, config);
            material.setConfig(config);
        }
    }

    public static void setupModuleConfigsPre() {
        moduleConfigDir = configDir.resolve("modules");
        if (!Files.exists(moduleConfigDir, new LinkOption[0]) || !Files.isDirectory(moduleConfigDir, new LinkOption[0])) {
            try {
                if (Files.exists(moduleConfigDir, new LinkOption[0]) && !Files.isDirectory(moduleConfigDir, new LinkOption[0])) {
                    LOGGER.warn("Config directory {} is a file, deleting", (Object)moduleConfigDir);
                    Files.delete(moduleConfigDir);
                }
                Files.createDirectory(moduleConfigDir, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create config directory " + moduleConfigDir, e);
            }
        }
        for (IModule module : ModuleHandler.getModules()) {
            DynamicSpecConfig config = new DynamicSpecConfig((CommentedConfig)CommentedFileConfig.builder(moduleConfigDir.resolve(module.getName() + ".toml")).sync().backingMapCreator(LinkedHashMap::new).autosave().build());
            MODULE_CONFIGS.put(module, config);
            ModuleData data = ModuleHandler.getModuleData(module);
            data.setConfig(config);
            module.defineModuleConfigPre(data, config);
            module.defineMaterialConfigPre(data, Collections.unmodifiableNavigableMap(MATERIAL_CONFIGS));
        }
    }

    public static void setupModuleConfigs() {
        for (IModule module : ModuleHandler.getModules()) {
            IDynamicSpecConfig config = MODULE_CONFIGS.get(module);
            ModuleData data = ModuleHandler.getModuleData(module);
            module.defineModuleConfig(data, config);
            module.defineMaterialConfig(data, Collections.unmodifiableNavigableMap(MATERIAL_CONFIGS));
        }
    }

    static {
        MATERIAL_CONFIGS = new TreeMap();
        MODULE_CONFIGS = new TreeMap();
        ingot = true;
        gem = true;
        crystal = true;
        dust = true;
        ingotPlain = true;
        gemPlain = true;
        crystalPlain = true;
        dustPlain = true;
        nonPlainUsedPrefix = false;
        strictUsedPrefix = false;
        DEFAULT_GEM_OVERRIDES = Lists.newArrayList((Object[])new String[]{"Coal", "Diamond", "Emerald", "Lapis", "Prismarine", "Quartz"});
        DEFAULT_CRYSTAL_OVERRIDES = Lists.newArrayList();
        DEFAULT_DUST_OVERRIDES = Lists.newArrayList((Object[])new String[]{"Redstone"});
        GEM_OVERRIDES = new TreeSet<String>();
        CRYSTAL_OVERRIDES = new TreeSet<String>();
        DUST_OVERRIDES = new TreeSet<String>();
        DEFAULT_PREFERRED_MODS = Lists.newArrayList((Object[])new String[]{"minecraft", "jaopca"});
        PREFERRED_MODS = new ArrayList<String>();
        OREDICT_BLACKLIST = new TreeSet<String>();
        OREDICT_MODULE_BLACKLIST = new TreeSet<String>();
        CUSTOM_OREDICT = new ArrayList<String>();
        RECIPE_BLACKLIST = new TreeSet<ResourceLocation>();
        RECIPE_REGEX_BLACKLIST = new ArrayList<Pattern>();
        gammaValue = 2.0;
        resetColors = false;
        checkL10nUpdates = true;
        updateInterval = 3.0;
    }
}

