/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thaumcraft.recipes;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.ThaumcraftApi;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class SmeltingBonusRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int count;
    public final float chance;

    public SmeltingBonusRecipeAction(ResourceLocation key, Object input, Object output, int count, float chance) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.count = count;
        this.chance = chance;
    }

    @Override
    public boolean register() {
        ArrayList<Object> ins = new ArrayList<Object>();
        if (this.input instanceof String) {
            if (!ApiImpl.INSTANCE.getOredict().contains(this.input)) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
            }
            ins.add(this.input);
        } else {
            Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
            if (ing == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
            }
            for (ItemStack is : ing.func_193365_a()) {
                ins.add(is.func_77946_l());
            }
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        for (Object e : ins) {
            ThaumcraftApi.addSmeltingBonus(e, (ItemStack)stack, (float)this.chance);
        }
        return true;
    }
}

