/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thaumcraft;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import thaumcraft.api.aspects.Aspect;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.thaumcraft.ThaumcraftHelper;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"thaumcraft"})
public class ThaumcraftModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("Cinnabar", "Copper", "Gold", "Iron", "Lead", "NetherQuartz", "Quartz", "Silver", "Tin"));
    private final IForm clusterForm = ApiImpl.INSTANCE.newForm(this, "thaumcraft_cluster", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT).setSecondaryName("cluster").setDefaultMaterialBlacklist(BLACKLIST);
    private List<ResourceLocation> recipeKeys = new ArrayList<ResourceLocation>();

    @Override
    public String getName() {
        return "thaumcraft";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"nugget");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.clusterForm.toRequest());
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        ThaumcraftHelper helper = ThaumcraftHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        for (IMaterial material : this.clusterForm.getMaterials()) {
            IItemInfo clusterInfo = itemFormType.getMaterialFormInfo(this.clusterForm, material);
            String clusterOredict = miscHelper.getOredictName("cluster", material.getName());
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String materialOredict = miscHelper.getOredictName(material.getType().getFormName(), material.getName());
            String nuggetOredict = miscHelper.getOredictName("nugget", material.getName());
            helper.registerSpecialMiningRecipe(miscHelper.getRecipeKey("thaumcraft.ore_to_cluster_mining", material.getName()), oreOredict, clusterInfo, 1, 1.0f);
            ResourceLocation recipeKey = miscHelper.getRecipeKey("thaumcraft.ore_to_cluster_crucible", material.getName());
            this.recipeKeys.add(recipeKey);
            helper.registerCrucibleRecipe(recipeKey, "METALPURIFICATION", oreOredict, new Object[]{Aspect.METAL, 5, Aspect.ORDER, 5}, clusterInfo, 1);
            ((JAOPCAApi)api).registerSmeltingRecipe(miscHelper.getRecipeKey("thaumcraft.cluster_to_material", material.getName()), clusterOredict, materialOredict, 2, 1.0f);
            helper.registerSmeltingBonusRecipe(miscHelper.getRecipeKey("thaumcraft.cluster_to_nugget", material.getName()), clusterOredict, nuggetOredict, 1, 0.33f);
        }
        for (IMaterial material : moduleData.getMaterials()) {
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String nuggetOredict = miscHelper.getOredictName("nugget", material.getName());
            helper.registerSmeltingBonusRecipe(miscHelper.getRecipeKey("thaumcraft.ore_to_nugget", material.getName()), oreOredict, nuggetOredict, 1, 0.33f);
        }
    }

    @Override
    public void onPostInit(IModuleData moduleData, FMLPostInitializationEvent event) {
        ThaumcraftHelper.INSTANCE.registerRecipesToResearch("METALPURIFICATION", this.recipeKeys);
    }

    @Override
    public Map<String, String> getLegacyRemaps() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"cluster", (Object)"thaumcraft_cluster");
        return builder.build();
    }
}

