/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.techreborn.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.recipes.OreRecipeInput;
import techreborn.api.recipe.machines.IndustrialGrinderRecipe;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class IndustrialGrinderRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final int time;
    public final int energy;
    public final Object[] output;

    public IndustrialGrinderRecipeAction(ResourceLocation key, Object itemInput, int itemInputCount, Object fluidInput, int fluidInputAmount, int time, int energy, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.time = time;
        this.energy = energy;
        this.output = output;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean register() {
        ArrayList<Object> ins = new ArrayList<Object>();
        if (this.itemInput instanceof String) {
            if (!ApiImpl.INSTANCE.getOredict().contains(this.itemInput)) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.itemInput);
            }
            ins.add(new OreRecipeInput((String)this.itemInput, this.itemInputCount));
        } else {
            Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.itemInput);
            if (ing == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.itemInput);
            }
            for (ItemStack itemStack : ing.func_193365_a()) {
                ins.add(MiscHelper.INSTANCE.resizeItemStack(itemStack, this.itemInputCount));
            }
        }
        FluidStack fluidStack = MiscHelper.INSTANCE.getFluidStack(this.fluidInput, this.fluidInputAmount);
        if (fluidStack == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.fluidInput);
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int i = 0;
        while (i < this.output.length) {
            void var6_12;
            ItemStack stack;
            Object out = this.output[i];
            Integer n = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                Integer n2 = (Integer)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, var6_12.intValue())).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(stack);
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        for (Object e : ins) {
            IndustrialGrinderRecipe recipe = new IndustrialGrinderRecipe(e, fluidStack, null, null, null, null, this.time, this.energy);
            for (ItemStack out : outputs) {
                recipe.addOutput(out);
            }
            RecipeHandler.addRecipe((IBaseRecipeType)recipe);
        }
        return true;
    }
}

