/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.techreborn.recipes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.recipes.OreRecipeInput;
import techreborn.api.recipe.machines.ImplosionCompressorRecipe;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class ImplosionCompressorRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] input;
    public final Object[] output;
    public final int time;
    public final int energy;

    public ImplosionCompressorRecipeAction(ResourceLocation key, Object[] input, Object[] output, int time, int energy) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public boolean register() {
        ArrayList inputs = new ArrayList();
        int i = 0;
        while (i < this.input.length) {
            Object in = this.input[i];
            Integer inc = 1;
            if (++i < this.input.length && this.input[i] instanceof Integer) {
                inc = (Integer)this.input[i];
                ++i;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            if (in instanceof String) {
                if (!ApiImpl.INSTANCE.getOredict().contains(in)) {
                    throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
                }
                list.add(new OreRecipeInput((String)in, inc.intValue()));
            } else {
                Ingredient ing = MiscHelper.INSTANCE.getIngredient(in);
                if (ing == null) {
                    throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + in);
                }
                for (ItemStack is : ing.func_193365_a()) {
                    list.add(MiscHelper.INSTANCE.resizeItemStack(is, inc));
                }
            }
            inputs.add(list);
        }
        if (inputs.isEmpty()) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + this.key + ": " + Arrays.deepToString(this.input));
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(stack);
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        for (List ins : Lists.cartesianProduct(inputs)) {
            ImplosionCompressorRecipe recipe = new ImplosionCompressorRecipe(null, null, null, null, this.time, this.energy);
            for (Object in : ins) {
                recipe.addInput(in);
            }
            for (ItemStack out : outputs) {
                recipe.addOutput(out);
            }
            RecipeHandler.addRecipe((IBaseRecipeType)recipe);
        }
        return true;
    }
}

