/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.techreborn;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.techreborn.TechRebornHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"techreborn"})
public class TechRebornModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("Bauxite", "Cinnabar", "Coal", "Copper", "Diamond", "Emerald", "Galena", "Gold", "Iron", "Lapis", "Lead", "Olivine", "Peridot", "Platinum", "Pyrite", "Redstone", "Ruby", "Sapphire", "Silver", "Sodalite", "Sheldonite", "Sphalerite", "Tin", "Tungsten"));

    @Override
    public String getName() {
        return "techreborn";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dust");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.copyOf(Arrays.asList(MaterialType.ORE));
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        TechRebornHelper helper = TechRebornHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String dustOredict = miscHelper.getOredictName("dust", material.getName());
            helper.registerGrinderRecipe(miscHelper.getRecipeKey("techreborn.ore_to_dust_grinder", material.getName()), oreOredict, 1, dustOredict, material.getType().isDust() ? 4 : 2, 300, 2);
        }
    }
}

