/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.techreborn;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import org.apache.commons.lang3.ArrayUtils;
import techreborn.init.ModFluids;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.techreborn.TechRebornHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"techreborn"})
public class TechRebornIndustrialIngotModule
implements IModule {
    static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("Aluminium", "Aluminum", "Amethyst", "Apatite", "Ardite", "Bauxite", "Cinnabar", "Coal", "Cobalt", "Copper", "Diamond", "Emerald", "Galena", "Gold", "Iridium", "Iron", "Lapis", "Lead", "Malachite", "NetherQuartz", "Nickel", "Niter", "Osmium", "Peridot", "Pitchblende", "Pyrite", "Quartz", "Redstone", "Ruby", "Saltpeter", "Sapphire", "Sheldonite", "Silver", "Sodalite", "Sphalerite", "Sulfur", "Tanzanite", "Teslatite", "Tin", "Topaz", "Tungsten", "Uranium", "Zinc"));
    private static Set<String> configWaterBlacklist = new TreeSet<String>();
    private static Set<String> configMercuryBlacklist = new TreeSet<String>();
    private static Set<String> configSodiumPersulfateBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "techreborn_industrial_ingot";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dust");
        builder.put((Object)1, (Object)"dust");
        builder.put((Object)1, (Object)"small_dust");
        builder.put((Object)2, (Object)"small_dust");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.waterMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have water industrial grinder recipes added."), configWaterBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.mercuryMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have mercury industrial grinder recipes added."), configMercuryBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.sodiumPersulfateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have sodium persulfate\t industrial grinder recipes added."), configSodiumPersulfateBlacklist);
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        TechRebornHelper helper = TechRebornHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            Object[] output;
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String dustOredict = miscHelper.getOredictName("dust", material.getName());
            String extraSmallDustOredict = miscHelper.getOredictName("dustSmall", material.getExtra(1).getName());
            String extraDustOredict = miscHelper.getOredictName("dust", material.getExtra(1).getName());
            String secondExtraSmallDustOredict = miscHelper.getOredictName("dustSmall", material.getExtra(2).getName());
            if (!configWaterBlacklist.contains(material.getName())) {
                output = new Object[]{dustOredict, 2};
                if (material.hasExtra(1)) {
                    output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraSmallDustOredict, 1});
                }
                if (material.hasExtra(2)) {
                    output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{secondExtraSmallDustOredict, 1});
                }
                helper.registerIndustrialGrinderRecipe(miscHelper.getRecipeKey("techreborn.ore_to_dust_water", material.getName()), oreOredict, 1, FluidRegistry.WATER, 1000, 100, 64, output);
            }
            if (!configMercuryBlacklist.contains(material.getName())) {
                output = new Object[]{dustOredict, 3};
                if (material.hasExtra(1)) {
                    output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraDustOredict, 1});
                }
                if (material.hasExtra(2)) {
                    output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{secondExtraSmallDustOredict, 1});
                }
                helper.registerIndustrialGrinderRecipe(miscHelper.getRecipeKey("techreborn.ore_to_dust_mercury", material.getName()), oreOredict, 1, ModFluids.MERCURY, 1000, 100, 64, output);
            }
            if (configSodiumPersulfateBlacklist.contains(material.getName())) continue;
            output = new Object[]{dustOredict, 3};
            if (material.hasExtra(1)) {
                output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraSmallDustOredict, 1});
            }
            if (material.hasExtra(2)) {
                output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{secondExtraSmallDustOredict, 1});
            }
            helper.registerIndustrialGrinderRecipe(miscHelper.getRecipeKey("techreborn.ore_to_dust_sodium_persulfate", material.getName()), oreOredict, 1, ModFluids.SODIUMPERSULFATE, 1000, 100, 64, output);
        }
    }
}

