/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.tconstruct.recipes;

import java.util.Objects;
import java.util.function.ToIntFunction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.compat.tconstruct.TConstructHelper;
import thelm.jaopca.utils.MiscHelper;

public class MeltingRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int outputAmount;
    public final ToIntFunction<FluidStack> temperature;

    public MeltingRecipeAction(ResourceLocation key, Object input, Object output, int outputAmount, ToIntFunction<FluidStack> temperature) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.outputAmount = outputAmount;
        this.temperature = temperature;
    }

    @Override
    public boolean register() {
        RecipeMatch ing = TConstructHelper.INSTANCE.getRecipeMatch(this.input, 1, this.outputAmount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        FluidStack stack = MiscHelper.INSTANCE.getFluidStack(this.output, this.outputAmount);
        if (stack == null) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(ing, stack, this.temperature.applyAsInt(stack)));
        return true;
    }
}

