/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.tconstruct.recipes;

import java.util.Objects;
import java.util.function.ToIntFunction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.PreferenceCastingRecipe;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.compat.tconstruct.TConstructHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class BasinCastingRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object cast;
    public final Object input;
    public final int inputAmount;
    public final Object output;
    public final ToIntFunction<FluidStack> time;
    public final boolean consumeCast;
    public final boolean switchSlots;

    public BasinCastingRecipeAction(ResourceLocation key, Object cast, Object input, int inputAmount, Object output, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        this.key = Objects.requireNonNull(key);
        this.cast = cast;
        this.input = input;
        this.inputAmount = inputAmount;
        this.output = output;
        this.time = time;
        this.consumeCast = consumeCast;
        this.switchSlots = switchSlots;
    }

    @Override
    public boolean register() {
        FluidStack ing = MiscHelper.INSTANCE.getFluidStack(this.input, this.inputAmount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        RecipeMatch match = TConstructHelper.INSTANCE.getRecipeMatch(this.cast, 1, 1);
        if (this.output instanceof String) {
            if (!ApiImpl.INSTANCE.getOredict().contains(this.output)) {
                throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
            }
            TinkerRegistry.registerBasinCasting((ICastingRecipe)new PreferenceCastingRecipe((String)this.output, match, ing, this.time.applyAsInt(ing), this.consumeCast, this.switchSlots));
        } else {
            ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, 1);
            if (stack.func_190926_b()) {
                throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
            }
            TinkerRegistry.registerBasinCasting((ICastingRecipe)new CastingRecipe(stack, match, ing, this.time.applyAsInt(ing), this.consumeCast, this.switchSlots));
        }
        return true;
    }
}

