/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.tconstruct;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.ToIntFunction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import org.apache.commons.lang3.StringUtils;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.tconstruct.TConstructHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"tconstruct"})
public class TConstructModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>();
    private static boolean jaopcaOnly = true;

    @Override
    public String getName() {
        return "tconstruct";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"molten");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT, MaterialType.GEM, MaterialType.CRYSTAL);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        if (BLACKLIST.isEmpty()) {
            TinkerRegistry.getMaterialIntegrations().stream().filter(mi -> mi.fluid != null).map(mi -> mi.oreSuffix).filter(StringUtils::isNotEmpty).forEach(BLACKLIST::add);
            BLACKLIST.add("Emerald");
        }
        return BLACKLIST;
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        jaopcaOnly = config.getDefinedBoolean("recipes.jaopcaOnly", jaopcaOnly, "Should the module only add recipes for materials with JAOPCA molten fluids.");
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        TConstructHelper helper = TConstructHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<IMaterial> moltenMaterials = ((JAOPCAApi)api).getForm("molten").getMaterials();
        ToIntFunction<FluidStack> tempFunction = stack -> stack.getFluid().getTemperature(stack) - 300;
        for (IMaterial material : moduleData.getMaterials()) {
            if (jaopcaOnly && !moltenMaterials.contains(material)) continue;
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String moltenName = miscHelper.getFluidName("", material.getName());
            boolean isIngot = material.getType().isIngot();
            int amount = (int)Math.floor((double)(isIngot ? 144 : 666) * Config.oreToIngotRatio);
            helper.registerMeltingRecipe(miscHelper.getRecipeKey("tconstruct.ore_to_molten", material.getName()), oreOredict, moltenName, amount, tempFunction);
        }
    }
}

