/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.railcraft.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import mods.railcraft.api.crafting.Crafters;
import mods.railcraft.api.crafting.IRockCrusherCrafter;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class RockCrusherRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int time;
    public final Object[] output;

    public RockCrusherRecipeAction(ResourceLocation key, Object input, int time, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.time = time;
        this.output = output;
    }

    @Override
    public boolean register() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<Pair> outputs = new ArrayList<Pair>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(Pair.of((Object)stack, (Object)chance));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        IRockCrusherCrafter.IRockCrusherRecipeBuilder builder = (IRockCrusherCrafter.IRockCrusherRecipeBuilder)((IRockCrusherCrafter.IRockCrusherRecipeBuilder)Crafters.rockCrusher().makeRecipe((Object)ing).name(this.key)).time(this.time);
        for (Pair out : outputs) {
            builder.addOutput((ItemStack)out.getLeft(), ((Float)out.getRight()).floatValue());
        }
        builder.register();
        return true;
    }
}

