/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.railcraft;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.railcraft.RailcraftHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"railcraft"})
public class RailcraftNonIngotModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("Coal", "Diamond", "Emerald", "Lapis", "Niter", "Redstone", "Saltpeter", "Sulfur"));

    @Override
    public String getName() {
        return "railcraft_non_ingot";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        RailcraftHelper helper = RailcraftHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String materialOredict = miscHelper.getOredictName(material.getType().getFormName(), material.getName());
            if (material.getType().isCrystalline()) {
                helper.registerRockCrusherRecipe(miscHelper.getRecipeKey("railcraft.ore_to_material", material.getName()), oreOredict, 100, materialOredict, 1, Float.valueOf(1.0f), materialOredict, 1, Float.valueOf(0.85f), materialOredict, 1, Float.valueOf(0.25f));
                continue;
            }
            helper.registerRockCrusherRecipe(miscHelper.getRecipeKey("railcraft.ore_to_material", material.getName()), oreOredict, 100, materialOredict, 5, Float.valueOf(1.0f), materialOredict, 1, Float.valueOf(0.85f), materialOredict, 1, Float.valueOf(0.35f));
        }
    }

    static {
        if (Loader.isModLoaded((String)"forestry")) {
            Collections.addAll(BLACKLIST, "Apatite");
        }
    }
}

