/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.magneticraft.recipes;

import com.cout970.magneticraft.api.MagneticraftApi;
import com.cout970.magneticraft.api.registries.machines.hydraulicpress.HydraulicPressMode;
import com.cout970.magneticraft.api.registries.machines.hydraulicpress.IHydraulicPressRecipeManager;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class HydraulicPressRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;
    public final float time;
    public final int mode;

    public HydraulicPressRecipeAction(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, float time, int mode) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
        this.mode = mode;
    }

    @Override
    public boolean register() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        IHydraulicPressRecipeManager manager = MagneticraftApi.getHydraulicPressRecipeManager();
        HydraulicPressMode pressMode = HydraulicPressMode.values()[this.mode];
        for (ItemStack in : ing.func_193365_a()) {
            manager.registerRecipe(manager.createRecipe(MiscHelper.INSTANCE.resizeItemStack(in, this.inputCount), stack, this.time, pressMode, false));
        }
        return true;
    }
}

