/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.magneticraft.recipes;

import com.cout970.magneticraft.api.MagneticraftApi;
import com.cout970.magneticraft.api.registries.machines.grinder.IGrinderRecipeManager;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class GrinderRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int outputCount;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final float secondOutputChance;
    public final float time;

    public GrinderRecipeAction(ResourceLocation key, Object input, Object output, int outputCount, float time) {
        this(key, input, output, outputCount, ItemStack.field_190927_a, 0, 0.0f, time);
    }

    public GrinderRecipeAction(ResourceLocation key, Object input, Object output, int outputCount, Object secondOutput, int secondOutputCount, float secondOutputChance, float time) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondOutputChance = secondOutputChance;
        this.time = time;
    }

    @Override
    public boolean register() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack1 = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack1.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        ItemStack stack2 = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        IGrinderRecipeManager manager = MagneticraftApi.getGrinderRecipeManager();
        for (ItemStack in : ing.func_193365_a()) {
            manager.registerRecipe(manager.createRecipe(in.func_77946_l(), stack1, stack2, this.secondOutputChance, this.time, false));
        }
        return true;
    }
}

