/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.integrateddynamics.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientsAndFluidStackRecipeComponent;
import org.cyclops.integrateddynamics.block.BlockSqueezer;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class SqueezerRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] itemOutput;
    public final Object fluidOutput;
    public final int fluidOutputAmount;

    public SqueezerRecipeAction(ResourceLocation key, Object input, Object[] itemOutput) {
        this(key, input, itemOutput, null, 0);
    }

    public SqueezerRecipeAction(ResourceLocation key, Object input, Object[] itemOutput, Object fluidOutput, int fluidOutputAmount) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.itemOutput = itemOutput;
        this.fluidOutput = fluidOutput;
        this.fluidOutputAmount = fluidOutputAmount;
    }

    @Override
    public boolean register() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<IngredientRecipeComponent> itemResults = new ArrayList<IngredientRecipeComponent>();
        int i = 0;
        while (i < this.itemOutput.length) {
            ItemStack stack;
            Object out = this.itemOutput[i];
            Integer count = 1;
            if (++i < this.itemOutput.length && this.itemOutput[i] instanceof Integer) {
                count = (Integer)this.itemOutput[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.itemOutput.length && this.itemOutput[i] instanceof Float) {
                chance = (Float)this.itemOutput[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            IngredientRecipeComponent component = new IngredientRecipeComponent(stack);
            component.setChance(chance.floatValue());
            itemResults.add(component);
        }
        FluidStack fluidStack = MiscHelper.INSTANCE.getFluidStack(this.fluidOutput, this.fluidOutputAmount);
        if (itemResults.isEmpty() && fluidStack == null) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.itemOutput) + ", " + this.fluidOutput);
        }
        IngredientRecipeComponent in = new IngredientRecipeComponent(ing);
        IngredientsAndFluidStackRecipeComponent out = new IngredientsAndFluidStackRecipeComponent(itemResults, fluidStack);
        DummyPropertiesComponent props = new DummyPropertiesComponent();
        BlockSqueezer.getInstance().getRecipeRegistry().registerRecipe(this.key.toString(), (IRecipeInput)in, (IRecipeOutput)out, (IRecipeProperties)props);
        return true;
    }
}

