/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.ic2.recipes;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.compat.ic2.IC2Helper;
import thelm.jaopca.utils.MiscHelper;

public class OreWashingRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final int waterAmount;
    public final Object[] output;

    public OreWashingRecipeAction(ResourceLocation key, Object input, int inputCount, int waterAmount, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.waterAmount = waterAmount;
        this.output = output;
    }

    @Override
    public boolean register() {
        IRecipeInput ing = IC2Helper.INSTANCE.getRecipeInput(this.input, this.inputCount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(stack);
        }
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("amount", this.waterAmount);
        return Recipes.oreWashing.addRecipe((Object)ing, outputs, metadata, false);
    }
}

