/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.hbm.recipes;

import com.hbm.inventory.CrystallizerRecipes;
import com.hbm.inventory.RecipesCommon;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class CrystallizerRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int count;

    public CrystallizerRecipeAction(ResourceLocation key, Object input, Object output, int count) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.count = count;
    }

    @Override
    public boolean register() {
        ArrayList<Object> ins = new ArrayList<Object>();
        if (this.input instanceof String) {
            if (!ApiImpl.INSTANCE.getOredict().contains(this.input)) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
            }
            ins.add(this.input);
        } else {
            Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
            if (ing == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
            }
            for (ItemStack itemStack : ing.func_193365_a()) {
                ins.add(new RecipesCommon.ComparableStack(itemStack).singulize());
            }
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        try {
            Field mapField = Arrays.stream(CrystallizerRecipes.class.getDeclaredFields()).filter(f -> Map.class.isAssignableFrom(f.getType())).findFirst().get();
            mapField.setAccessible(true);
            Map map = (Map)mapField.get(null);
            for (Object e : ins) {
                map.put(e, stack);
            }
            return true;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access crystallizer recipe map.");
        }
    }
}

