/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.foundry.recipes;

import exter.foundry.api.FoundryAPI;
import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import java.util.Objects;
import java.util.function.ToIntFunction;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.compat.foundry.FoundryHelper;
import thelm.jaopca.utils.MiscHelper;

public class CastingRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object mold;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object output;
    public final int outputCount;
    public final ToIntFunction<FluidStack> speed;

    public CastingRecipeAction(ResourceLocation key, Object fluidInput, int fluidInputAmount, Object mold, Object output, int outputCount, ToIntFunction<FluidStack> speed) {
        this(key, fluidInput, fluidInputAmount, mold, ItemStack.field_190927_a, 0, output, outputCount, speed);
    }

    public CastingRecipeAction(ResourceLocation key, Object fluidInput, int fluidInputAmount, Object mold, Object itemInput, int itemInputCount, Object output, int outputCount, ToIntFunction<FluidStack> speed) {
        this.key = Objects.requireNonNull(key);
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.mold = mold;
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.speed = speed;
    }

    @Override
    public boolean register() {
        FluidStack fluidIng = MiscHelper.INSTANCE.getFluidStack(this.fluidInput, this.fluidInputAmount);
        if (fluidIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.fluidInput);
        }
        Ingredient moldIng = MiscHelper.INSTANCE.getIngredient(this.mold);
        if (moldIng == null) {
            throw new IllegalArgumentException("Empty mold in recipe " + this.key + ": " + this.mold);
        }
        IItemMatcher itemIng = FoundryHelper.INSTANCE.getItemMatcher(this.itemInput, this.itemInputCount);
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        for (ItemStack moldIn : moldIng.func_193365_a()) {
            FoundryAPI.CASTING_MANAGER.addRecipe((IItemMatcher)new ItemStackMatcher(stack), fluidIng, moldIn.func_77946_l(), itemIng, this.speed.applyAsInt(fluidIng));
        }
        return true;
    }
}

