/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.foundry.fluids;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.fluids.JAOPCAFluidBlock;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCALiquidMetalFluidBlock
extends JAOPCAFluidBlock {
    private Optional<IBlockState> solidState = Optional.empty();

    public JAOPCALiquidMetalFluidBlock(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(fluid, settings);
    }

    public void tryHarden(World world, BlockPos pos, IBlockState state) {
        if (this.isSourceBlock((IBlockAccess)world, pos)) {
            if (!this.solidState.isPresent()) {
                MiscHelper helper = MiscHelper.INSTANCE;
                List<ItemStack> list = OreDictionary.getOres((String)helper.getOredictName("block", this.getMaterial().getName()), (boolean)false).stream().filter(is -> ForgeRegistries.BLOCKS.getValue(is.func_77973_b().getRegistryName()) != Blocks.field_150350_a).collect(Collectors.toList());
                ItemStack stack = helper.getPreferredItemStack(list, 1);
                this.solidState = Optional.ofNullable(this.getBlockStateFromItemStack(stack));
            }
            if (!this.solidState.isPresent()) {
                return;
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (world.func_180495_p(pos.func_177972_a(facing)).func_185904_a() != Material.field_151586_h) continue;
                world.func_175656_a(pos, this.solidState.get());
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f, false);
                for (int i = 0; i < 8; ++i) {
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                }
                return;
            }
        }
    }

    public IBlockState getBlockStateFromItemStack(ItemStack stack) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(stack.func_77973_b().getRegistryName());
        if (block != Blocks.field_150350_a) {
            int meta = stack.func_77960_j();
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                if (state == null || block.func_180651_a(state) != meta) continue;
                return state;
            }
        }
        return null;
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        return !world.func_180495_p(pos).func_185904_a().func_76224_d() && super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_185904_a().func_76224_d() && super.displaceIfPossible(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        this.tryHarden(world, pos, state);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.tryHarden(world, pos, state);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            entity.field_70159_w *= 0.5;
            entity.field_70179_y *= 0.5;
        }
        if (!entity.func_70045_F()) {
            if (!(entity instanceof EntityItem)) {
                entity.func_70097_a(DamageSource.field_76371_c, 4.0f);
            }
            entity.func_70015_d(15);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double dz;
        double dy;
        double dx;
        if (this.temperature < 1200) {
            return;
        }
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && !world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
            if (rand.nextInt(100) == 0) {
                dx = (float)pos.func_177958_n() + rand.nextFloat();
                dy = (double)pos.func_177956_o() + state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e;
                dz = (float)pos.func_177952_p() + rand.nextFloat();
                world.func_175688_a(EnumParticleTypes.LAVA, dx, dy, dz, 0.0, 0.0, 0.0, new int[0]);
                world.func_184134_a(dx, dy, dz, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(200) == 0) {
                world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
        BlockPos down = pos.func_177977_b();
        if (rand.nextInt(10) == 0 && world.func_180495_p(down).isSideSolid((IBlockAccess)world, down, EnumFacing.UP) && !world.func_180495_p(down).func_185904_a().func_76230_c()) {
            dx = (float)pos.func_177958_n() + rand.nextFloat();
            dy = (double)pos.func_177956_o() - 1.05;
            dz = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.DRIP_LAVA, dx, dy, dz, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

