/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.foundry;

import exter.foundry.api.FoundryAPI;
import exter.foundry.fluid.LiquidMetalRegistry;
import exter.foundry.item.FoundryItems;
import exter.foundry.item.ItemMold;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.ToIntFunction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.foundry.FoundryHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"foundry@[3,)"})
public class FoundryCompatModule
implements IModule {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> BLACKLIST = new TreeSet<String>();
    private static Set<String> configMaterialToLiquidBlacklist = new TreeSet<String>();
    private static Set<String> configBlockToLiquidBlacklist = new TreeSet<String>();
    private static Set<String> configNuggetToLiquidBlacklist = new TreeSet<String>();
    private static Set<String> configDustToLiquidBlacklist = new TreeSet<String>();
    private static Set<String> configTinyDustToLiquidBlacklist = new TreeSet<String>();
    private static Set<String> configSmallDustToLiquidBlacklist = new TreeSet<String>();
    private static Set<String> configPlateToLiquidBlacklist = new TreeSet<String>();
    private static Set<String> configGearToLiquidBlacklist = new TreeSet<String>();
    private static Set<String> configToMaterialBlacklist = new TreeSet<String>();
    private static Set<String> configTableToMaterialBlacklist = new TreeSet<String>();
    private static Set<String> configToBlockBlacklist = new TreeSet<String>();
    private static Set<String> configTableToBlockBlacklist = new TreeSet<String>();
    private static Set<String> configToNuggetBlacklist = new TreeSet<String>();
    private static Set<String> configToDustBlacklist = new TreeSet<String>();
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configTableToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configToGearBlacklist = new TreeSet<String>();
    private static Set<String> configToRodBlacklist = new TreeSet<String>();
    private static Set<String> configTableToRodBlacklist = new TreeSet<String>();
    private static Set<String> configMoltenToMaterialBlacklist = new TreeSet<String>();
    private static Set<String> configTableMoltenToMaterialBlacklist = new TreeSet<String>();
    private static Set<String> configMoltenToBlockBlacklist = new TreeSet<String>();
    private static Set<String> configTableMoltenToBlockBlacklist = new TreeSet<String>();
    private static Set<String> configMoltenToNuggetBlacklist = new TreeSet<String>();
    private static Set<String> configMoltenToDustBlacklist = new TreeSet<String>();
    private static Set<String> configMoltenToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configTableMoltenToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configMoltenToGearBlacklist = new TreeSet<String>();
    private static Set<String> configMoltenToRodBlacklist = new TreeSet<String>();
    private static Set<String> configTableMoltenToRodBlacklist = new TreeSet<String>();
    private static boolean jaopcaOnly = false;

    @Override
    public String getName() {
        return "foundry_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        BLACKLIST.addAll(LiquidMetalRegistry.INSTANCE.getFluidNames());
        Collections.addAll(BLACKLIST, "Aluminum", "Constantan");
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.materialToLiquidMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have material melting recipes added."), configMaterialToLiquidBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.blockToLiquidMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have block melting recipes added."), configBlockToLiquidBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.nuggetToLiquidMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have nugget melting recipes added."), configNuggetToLiquidBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.dustToLiquidMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have dust melting recipes added."), configDustToLiquidBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.tinyDustToLiquidMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have tiny dust melting recipes added."), configTinyDustToLiquidBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.smallDustToLiquidMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have small dust melting recipes added."), configSmallDustToLiquidBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.plateToLiquidMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have plate melting recipes added."), configPlateToLiquidBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.gearToLiquidMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have gear melting recipes added."), configGearToLiquidBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toMaterialMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have material casting recipes added."), configToMaterialBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.tableToMaterialMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have material casting table recipes added."), configTableToMaterialBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toBlockMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have block casting recipes added."), configToBlockBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.tableToBlockMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have block casting table recipes added."), configTableToBlockBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toNuggetMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have nugget casting recipes added."), configToNuggetBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have atomizer to dust recipes added."), configToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have plate casting recipes added."), configToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.tableToPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have plate casting table recipes added."), configTableToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toGearMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have gear casting recipes added."), configToGearBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.tableToRodMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have rod casting table recipes added."), configTableToRodBlacklist);
        jaopcaOnly = config.getDefinedBoolean("recipes.jaopcaOnly", jaopcaOnly, "Should the module only add recipes for materials with JAOPCA molten fluids.");
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.moltenToMaterialMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have material casting recipes added."), configMoltenToMaterialBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.tableMoltenToMaterialMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have material casting table recipes added."), configTableMoltenToMaterialBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.moltenToBlockMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have molten block casting recipes added."), configMoltenToBlockBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.tableMoltenToBlockMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have molten block casting table recipes added."), configTableMoltenToBlockBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.moltenToNuggetMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have molten nugget casting recipes added."), configMoltenToNuggetBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.moltenToDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have atomizer molten to dust recipes added."), configMoltenToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.moltenToPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have molten plate casting recipes added."), configMoltenToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.tableMoltenToPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have molten plate casting table recipes added."), configTableMoltenToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.moltenToGearMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have molten gear casting recipes added."), configMoltenToGearBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.tableMoltenToRodMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have molten rod casting table recipes added."), configTableMoltenToRodBlacklist);
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        FoundryHelper helper = FoundryHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<String> oredict = ((JAOPCAApi)api).getOredict();
        Set<IMaterial> moltenMaterials = ((JAOPCAApi)api).getForm("molten").getMaterials();
        int baseAmount = FoundryAPI.FLUID_AMOUNT_INGOT;
        ToIntFunction<FluidStack> tempFunction = stack -> stack.getFluid().getTemperature(stack);
        ToIntFunction<FluidStack> speedFunction = stack -> 100;
        ItemStack ingotCast = FoundryItems.mold((ItemMold.SubItem)ItemMold.SubItem.INGOT);
        ItemStack blockCast = FoundryItems.mold((ItemMold.SubItem)ItemMold.SubItem.BLOCK);
        ItemStack nuggetCast = FoundryItems.mold((ItemMold.SubItem)ItemMold.SubItem.NUGGET);
        ItemStack plateCast = FoundryItems.mold((ItemMold.SubItem)ItemMold.SubItem.PLATE);
        ItemStack gearCast = FoundryItems.mold((ItemMold.SubItem)ItemMold.SubItem.GEAR);
        ItemStack rodCast = FoundryItems.mold((ItemMold.SubItem)ItemMold.SubItem.ROD);
        for (IMaterial material : moduleData.getMaterials()) {
            String moltenName;
            String rodOredict;
            String gearOredict;
            String plateOredict;
            String dustOredict;
            String nuggetOredict;
            String blockOredict;
            String materialOredict;
            String liquidName;
            MaterialType type = material.getType();
            String name = material.getName();
            if (type.isIngot() && !BLACKLIST.contains(name) && FluidRegistry.isFluidRegistered((String)(liquidName = miscHelper.getFluidName("foundry_liquid", name)))) {
                String smallDustOredict;
                String tinyDustOredict;
                if (!configMaterialToLiquidBlacklist.contains(name)) {
                    materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                    helper.registerMeltingRecipe(miscHelper.getRecipeKey("foundry.material_to_liquid", name), materialOredict, 1, liquidName, baseAmount, tempFunction, speedFunction);
                }
                if (!configBlockToLiquidBlacklist.contains(name) && oredict.contains(blockOredict = miscHelper.getOredictName("block", name))) {
                    helper.registerMeltingRecipe(miscHelper.getRecipeKey("foundry.block_to_liquid", name), blockOredict, 1, liquidName, baseAmount * (material.isSmallStorageBlock() ? 4 : 9), tempFunction, speedFunction);
                }
                if (!configNuggetToLiquidBlacklist.contains(name) && oredict.contains(nuggetOredict = miscHelper.getOredictName("nugget", name))) {
                    helper.registerMeltingRecipe(miscHelper.getRecipeKey("foundry.nugget_to_liquid", name), nuggetOredict, 1, liquidName, baseAmount / 9, tempFunction, speedFunction);
                }
                if (!configDustToLiquidBlacklist.contains(name) && oredict.contains(dustOredict = miscHelper.getOredictName("dust", name))) {
                    helper.registerMeltingRecipe(miscHelper.getRecipeKey("foundry.dust_to_liquid", name), dustOredict, 1, liquidName, baseAmount, tempFunction, speedFunction);
                }
                if (!configTinyDustToLiquidBlacklist.contains(name) && oredict.contains(tinyDustOredict = miscHelper.getOredictName("dustTiny", name))) {
                    helper.registerMeltingRecipe(miscHelper.getRecipeKey("foundry.tiny_dust_to_liquid", name), tinyDustOredict, 1, liquidName, baseAmount / 9, tempFunction, speedFunction);
                }
                if (!configSmallDustToLiquidBlacklist.contains(name) && oredict.contains(smallDustOredict = miscHelper.getOredictName("dustSmall", name))) {
                    helper.registerMeltingRecipe(miscHelper.getRecipeKey("foundry.small_dust_to_liquid", name), smallDustOredict, 1, liquidName, baseAmount / 4, tempFunction, speedFunction);
                }
                if (!configPlateToLiquidBlacklist.contains(name) && oredict.contains(plateOredict = miscHelper.getOredictName("plate", name))) {
                    helper.registerMeltingRecipe(miscHelper.getRecipeKey("foundry.plate_to_liquid", name), plateOredict, 1, liquidName, baseAmount, tempFunction, speedFunction);
                }
                if (!configGearToLiquidBlacklist.contains(name) && oredict.contains(gearOredict = miscHelper.getOredictName("gear", name))) {
                    helper.registerMeltingRecipe(miscHelper.getRecipeKey("foundry.gear_to_liquid", name), gearOredict, 1, liquidName, baseAmount * 4, tempFunction, speedFunction);
                }
                if (!configToMaterialBlacklist.contains(name)) {
                    materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                    helper.registerCastingRecipe(miscHelper.getRecipeKey("foundry.liquid_to_material", name), liquidName, baseAmount, ingotCast, materialOredict, 1, speedFunction);
                }
                if (!configTableToMaterialBlacklist.contains(name)) {
                    materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                    helper.registerCastingTableRecipe(miscHelper.getRecipeKey("foundry.liquid_to_material_table", name), liquidName, baseAmount, materialOredict, 1, "ingot");
                }
                if (!configToBlockBlacklist.contains(name) && oredict.contains(blockOredict = miscHelper.getOredictName("block", name))) {
                    helper.registerCastingRecipe(miscHelper.getRecipeKey("foundry.liquid_to_block", name), liquidName, baseAmount * (material.isSmallStorageBlock() ? 4 : 9), blockCast, blockOredict, 1, speedFunction);
                }
                if (!configTableToBlockBlacklist.contains(name) && oredict.contains(blockOredict = miscHelper.getOredictName("block", name))) {
                    helper.registerCastingTableRecipe(miscHelper.getRecipeKey("foundry.liquid_to_block_table", name), liquidName, baseAmount * (material.isSmallStorageBlock() ? 4 : 9), blockOredict, 1, "block");
                }
                if (!configToNuggetBlacklist.contains(name) && oredict.contains(nuggetOredict = miscHelper.getOredictName("nugget", name))) {
                    helper.registerCastingRecipe(miscHelper.getRecipeKey("foundry.liquid_to_nugget", name), liquidName, this.ceilDiv(baseAmount, 9), nuggetCast, nuggetOredict, 1, speedFunction);
                }
                if (!configToDustBlacklist.contains(name) && oredict.contains(dustOredict = miscHelper.getOredictName("dust", name))) {
                    helper.registerAtomizerRecipe(miscHelper.getRecipeKey("foundry.liquid_to_dust", name), liquidName, baseAmount, dustOredict, 1);
                }
                if (!configToPlateBlacklist.contains(name) && oredict.contains(plateOredict = miscHelper.getOredictName("plate", name))) {
                    helper.registerCastingRecipe(miscHelper.getRecipeKey("foundry.liquid_to_plate", name), liquidName, baseAmount, plateCast, plateOredict, 1, speedFunction);
                }
                if (!configTableToPlateBlacklist.contains(name) && oredict.contains(plateOredict = miscHelper.getOredictName("plate", name))) {
                    helper.registerCastingTableRecipe(miscHelper.getRecipeKey("foundry.liquid_to_plate_table", name), liquidName, baseAmount, plateOredict, 1, "plate");
                }
                if (!configToGearBlacklist.contains(name) && oredict.contains(gearOredict = miscHelper.getOredictName("gear", name))) {
                    helper.registerCastingRecipe(miscHelper.getRecipeKey("foundry.liquid_to_gear", name), liquidName, baseAmount * 4, gearCast, gearOredict, 1, speedFunction);
                }
                if (!configToRodBlacklist.contains(name) && oredict.contains(rodOredict = miscHelper.getOredictName("rod", name))) {
                    helper.registerCastingRecipe(miscHelper.getRecipeKey("foundry.liquid_to_rod", name), liquidName, this.ceilDiv(baseAmount, 2), rodCast, rodOredict, 1, speedFunction);
                }
                if (!configTableToRodBlacklist.contains(name) && oredict.contains(rodOredict = miscHelper.getOredictName("rod", name))) {
                    helper.registerCastingTableRecipe(miscHelper.getRecipeKey("foundry.liquid_to_rod_table", name), liquidName, this.ceilDiv(baseAmount, 2), rodOredict, 1, "rod");
                }
            }
            if (!type.isIngot() || BLACKLIST.contains(name) || jaopcaOnly && !moltenMaterials.contains(material) || !FluidRegistry.isFluidRegistered((String)(moltenName = miscHelper.getFluidName("", name)))) continue;
            if (!configMoltenToMaterialBlacklist.contains(name)) {
                materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                helper.registerCastingRecipe(miscHelper.getRecipeKey("foundry.molten_to_material", name), moltenName, 144, ingotCast, materialOredict, 1, speedFunction);
            }
            if (!configTableMoltenToMaterialBlacklist.contains(name)) {
                materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                helper.registerCastingTableRecipe(miscHelper.getRecipeKey("foundry.molten_to_material_table", name), moltenName, 144, materialOredict, 1, "ingot");
            }
            if (!configMoltenToBlockBlacklist.contains(name) && oredict.contains(blockOredict = miscHelper.getOredictName("block", name))) {
                helper.registerCastingRecipe(miscHelper.getRecipeKey("foundry.molten_to_block", name), moltenName, 144 * (material.isSmallStorageBlock() ? 4 : 9), blockCast, blockOredict, 1, speedFunction);
            }
            if (!configTableMoltenToBlockBlacklist.contains(name) && oredict.contains(blockOredict = miscHelper.getOredictName("block", name))) {
                helper.registerCastingTableRecipe(miscHelper.getRecipeKey("foundry.molten_to_block_table", name), moltenName, 144 * (material.isSmallStorageBlock() ? 4 : 9), blockOredict, 1, "block");
            }
            if (!configMoltenToNuggetBlacklist.contains(name) && oredict.contains(nuggetOredict = miscHelper.getOredictName("nugget", name))) {
                helper.registerCastingRecipe(miscHelper.getRecipeKey("foundry.molten_to_nugget", name), moltenName, 16, nuggetCast, nuggetOredict, 1, speedFunction);
            }
            if (!configMoltenToDustBlacklist.contains(name) && oredict.contains(dustOredict = miscHelper.getOredictName("dust", name))) {
                helper.registerAtomizerRecipe(miscHelper.getRecipeKey("foundry.molten_to_dust", name), moltenName, 144, dustOredict, 1);
            }
            if (!configMoltenToPlateBlacklist.contains(name) && oredict.contains(plateOredict = miscHelper.getOredictName("plate", name))) {
                helper.registerCastingRecipe(miscHelper.getRecipeKey("foundry.molten_to_plate", name), moltenName, 144, plateCast, plateOredict, 1, speedFunction);
            }
            if (!configTableMoltenToPlateBlacklist.contains(name) && oredict.contains(plateOredict = miscHelper.getOredictName("plate", name))) {
                helper.registerCastingTableRecipe(miscHelper.getRecipeKey("foundry.molten_to_plate_table", name), moltenName, 144, plateOredict, 1, "plate");
            }
            if (!configMoltenToGearBlacklist.contains(name) && oredict.contains(gearOredict = miscHelper.getOredictName("gear", name))) {
                helper.registerCastingRecipe(miscHelper.getRecipeKey("foundry.molten_to_gear", name), moltenName, 576, gearCast, gearOredict, 1, speedFunction);
            }
            if (!configMoltenToRodBlacklist.contains(name) && oredict.contains(rodOredict = miscHelper.getOredictName("rod", name))) {
                helper.registerCastingRecipe(miscHelper.getRecipeKey("foundry.molten_to_rod", name), moltenName, 72, rodCast, rodOredict, 1, speedFunction);
            }
            if (configTableMoltenToRodBlacklist.contains(name) || !oredict.contains(rodOredict = miscHelper.getOredictName("rod", name))) continue;
            helper.registerCastingTableRecipe(miscHelper.getRecipeKey("foundry.molten_to_rod_table", name), moltenName, 72, rodOredict, 1, "rod");
        }
    }

    public int ceilDiv(int a, int b) {
        return a / b + (a % b == 0 ? 0 : 1);
    }
}

