/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.enderio;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.enderio.EnderIOHelper;
import thelm.jaopca.compat.enderio.EnderIOModule;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"enderio"})
public class EnderIONonIngotModule
implements IModule {
    private Map<IMaterial, IDynamicSpecConfig> configs;

    @Override
    public String getName() {
        return "enderio_non_ingot";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)1, (Object)"dust");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return EnderIOModule.BLACKLIST;
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        EnderIOHelper helper = EnderIOHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            Object[] objectArray;
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String materialOredict = miscHelper.getOredictName(material.getType().getFormName(), material.getName());
            IDynamicSpecConfig config = this.configs.get(material);
            String configByproduct = config.getDefinedString("enderio.byproduct", "minecraft:cobblestone", miscHelper.metaItemPredicate(), "The default byproduct material to output in Ender IO's sagmill.");
            ItemStack byproduct = miscHelper.parseMetaItem(configByproduct);
            if (material.getType().isCrystalline()) {
                Object[] objectArray2 = new Object[9];
                objectArray2[0] = materialOredict;
                objectArray2[1] = 2;
                objectArray2[2] = Float.valueOf(1.0f);
                objectArray2[3] = materialOredict;
                objectArray2[4] = 1;
                objectArray2[5] = Float.valueOf(0.5f);
                objectArray2[6] = byproduct;
                objectArray2[7] = 1;
                objectArray = objectArray2;
                objectArray2[8] = Float.valueOf(0.15f);
            } else {
                Object[] objectArray3 = new Object[6];
                objectArray3[0] = materialOredict;
                objectArray3[1] = 4;
                objectArray3[2] = Float.valueOf(1.0f);
                objectArray3[3] = byproduct;
                objectArray3[4] = 1;
                objectArray = objectArray3;
                objectArray3[5] = Float.valueOf(0.15f);
            }
            Object[] output = objectArray;
            if (material.hasExtra(1)) {
                String extraDustOredict = miscHelper.getOredictName("dust", material.getExtra(1).getName());
                output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraDustOredict, 1, Float.valueOf(0.1f)});
            }
            helper.registerSagMillRecipe(miscHelper.getRecipeKey("enderio.ore_to_material", material.getName()), oreOredict, 3600, "multiply_output", "ignore", output);
        }
    }
}

