/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.enderio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.enderio.EnderIOHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"enderio"})
public class EnderIOCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(Arrays.asList("Adamantine", "Aluminium", "Aluminum", "AluminumBrass", "Amordrine", "Angmallen", "Ardite", "AstralSilver", "Atlarus", "BlackSteel", "Blutonium", "Brass", "Bronze", "Carmot", "Celenegil", "CertusQuartz", "Ceruclase", "Charcoal", "Cobalt", "ConductiveIron", "Coal", "Copper", "Cyanite", "DamascusSteel", "DarkSteel", "DeepIron", "Diamond", "Draconium", "ElectricalSteel", "Electrum", "Emerald", "Enderium", "EnergeticAlloy", "Fluix", "Gold", "Graphite", "Haderoth", "Hepatizon", "Ignatius", "Infuscolium", "Inolashite", "Invar", "Iron", "Kalendrite", "Lapis", "Lead", "Lemurite", "Ludicrite", "Lumium", "Magnesium", "Manganese", "Manyullyn", "Midasium", "Mithril", "NaturalAluminum", "NetherQuartz", "Nickel", "Orichalcum", "Osmium", "Oureclase", "Platinum", "Prismarine", "Prometheum", "PulsatingIron", "Quartz", "Quicksilver", "RedstoneAlloy", "Rubracium", "Rutile", "Sanguinite", "ShadowIron", "ShadowSteel", "Signalum", "Silver", "Soularium", "Steel", "Tartarite", "Tin", "Titanium", "Tungsten", "Uranium", "VibrantAlloy", "Vulcanite", "Vyroxeres", "Yellorium", "Zinc"));
    private static Set<String> configMaterialToDustBlacklist = new TreeSet<String>();
    private static Set<String> configBlockToDustBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "enderio_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.materialToDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have sagmill material to dust recipes added."), configMaterialToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.blockToDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have sagmill block to dust recipes added."), configBlockToDustBlacklist);
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        EnderIOHelper helper = EnderIOHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<String> oredict = ((JAOPCAApi)api).getOredict();
        for (IMaterial material : moduleData.getMaterials()) {
            String dustOredict;
            MaterialType type = material.getType();
            String name = material.getName();
            if (!(type.isDust() || TO_DUST_BLACKLIST.contains(name) || configMaterialToDustBlacklist.contains(name))) {
                String materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                dustOredict = miscHelper.getOredictName("dust", name);
                if (oredict.contains(dustOredict)) {
                    helper.registerSagMillRecipe(miscHelper.getRecipeKey("enderio.material_to_dust", name), materialOredict, 2400, "none", "ignore", dustOredict, 1, Float.valueOf(1.0f));
                }
            }
            if (!type.isIngot() || TO_DUST_BLACKLIST.contains(name) || configBlockToDustBlacklist.contains(name)) continue;
            String blockOredict = miscHelper.getOredictName("block", name);
            dustOredict = miscHelper.getOredictName("dust", name);
            if (!oredict.contains(dustOredict)) continue;
            helper.registerSagMillRecipe(miscHelper.getRecipeKey("enderio.block_to_dust", name), blockOredict, 3600, "none", "ignore", dustOredict, material.isSmallStorageBlock() ? 4 : 9, Float.valueOf(1.0f));
        }
    }
}

