/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.embers.recipes;

import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class StampingRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object stamp;
    public final Object output;
    public final int outputCount;

    public StampingRecipeAction(ResourceLocation key, Object itemInput, Object stamp, Object output, int outputCount) {
        this(key, itemInput, null, 0, stamp, output, outputCount);
    }

    public StampingRecipeAction(ResourceLocation key, Object fluidInput, int fluidInputAmount, Object stamp, Object output, int outputCount) {
        this(key, ItemStack.field_190927_a, fluidInput, fluidInputAmount, stamp, output, outputCount);
    }

    public StampingRecipeAction(ResourceLocation key, Object itemInput, Object fluidInput, int fluidInputAmount, Object stamp, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.stamp = stamp;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public boolean register() {
        Ingredient itemIng = MiscHelper.INSTANCE.getIngredient(this.itemInput);
        FluidStack fluidIng = MiscHelper.INSTANCE.getFluidStack(this.fluidInput, this.fluidInputAmount);
        if (itemIng == null && fluidIng == null) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + this.key + ": " + this.itemInput + ", " + this.fluidInput);
        }
        Ingredient stampIng = MiscHelper.INSTANCE.getIngredient(this.stamp);
        if (stampIng == null) {
            throw new IllegalArgumentException("Empty stamp in recipe " + this.key + ": " + this.stamp);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        if (itemIng == null) {
            itemIng = Ingredient.field_193370_a;
        }
        return RecipeRegistry.stampingRecipes.add(new ItemStampingRecipe(itemIng, fluidIng, stampIng, stack));
    }
}

